/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public class V8ValueArrayBuffer
extends V8ValueObject {
    protected static final int BYTE_LENGTH_1 = 1;
    protected static final int BYTE_LENGTH_2 = 2;
    protected static final int BYTE_LENGTH_3 = 3;
    protected static final String PROPERTY_BYTE_LENGTH = "byteLength";
    protected ByteBuffer byteBuffer;
    protected ByteOrder byteOrder;

    V8ValueArrayBuffer(V8Runtime v8Runtime, long handle, ByteBuffer byteBuffer) throws JavetException {
        super(v8Runtime, handle);
        this.byteBuffer = byteBuffer;
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public boolean fromBytes(byte[] bytes) {
        if (bytes != null && bytes.length > 0 && bytes.length == this.byteBuffer.capacity()) {
            this.byteBuffer.put(bytes);
            return true;
        }
        return false;
    }

    public boolean fromDoubles(double[] doubles) {
        if (doubles != null && doubles.length > 0 && doubles.length == this.byteBuffer.capacity() >> 3) {
            this.byteBuffer.order(this.byteOrder).asDoubleBuffer().put(doubles);
            return true;
        }
        return false;
    }

    public boolean fromFloats(float[] floats) {
        if (floats != null && floats.length > 0 && floats.length == this.byteBuffer.capacity() >> 2) {
            this.byteBuffer.order(this.byteOrder).asFloatBuffer().put(floats);
            return true;
        }
        return false;
    }

    public boolean fromIntegers(int[] integers) {
        if (integers != null && integers.length > 0 && integers.length == this.byteBuffer.capacity() >> 2) {
            this.byteBuffer.order(this.byteOrder).asIntBuffer().put(integers);
            return true;
        }
        return false;
    }

    public boolean fromLongs(long[] longs) {
        if (longs != null && longs.length > 0 && longs.length == this.byteBuffer.capacity() >> 3) {
            this.byteBuffer.order(this.byteOrder).asLongBuffer().put(longs);
            return true;
        }
        return false;
    }

    public boolean fromShorts(short[] shorts) {
        if (shorts != null && shorts.length > 0 && shorts.length == this.byteBuffer.capacity() >> 1) {
            this.byteBuffer.order(this.byteOrder).asShortBuffer().put(shorts);
            return true;
        }
        return false;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int getByteLength() throws JavetException {
        return this.getInteger(PROPERTY_BYTE_LENGTH);
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.ArrayBuffer;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        this.byteOrder = byteOrder;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this.byteBuffer.capacity()];
        this.byteBuffer.get(bytes);
        return bytes;
    }

    public double[] toDoubles() {
        double[] doubles = new double[this.byteBuffer.capacity() >> 3];
        this.byteBuffer.order(this.byteOrder).asDoubleBuffer().get(doubles);
        return doubles;
    }

    public float[] toFloats() {
        float[] floats = new float[this.byteBuffer.capacity() >> 2];
        this.byteBuffer.order(this.byteOrder).asFloatBuffer().get(floats);
        return floats;
    }

    public int[] toIntegers() {
        int[] integers = new int[this.byteBuffer.capacity() >> 2];
        this.byteBuffer.order(this.byteOrder).asIntBuffer().get(integers);
        return integers;
    }

    public long[] toLongs() {
        long[] longs = new long[this.byteBuffer.capacity() >> 3];
        this.byteBuffer.order(this.byteOrder).asLongBuffer().get(longs);
        return longs;
    }

    public short[] toShorts() {
        short[] shorts = new short[this.byteBuffer.capacity() >> 1];
        this.byteBuffer.order(this.byteOrder).asShortBuffer().get(shorts);
        return shorts;
    }
}

