/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public final class JavetDateTimeUtils {
    public static final ZoneId ZONE_ID_UTC = ZoneId.of("UTC");

    private JavetDateTimeUtils() {
    }

    public static ZonedDateTime getUTCNow() {
        return ZonedDateTime.now(ZONE_ID_UTC);
    }

    public static ZonedDateTime toZonedDateTime(long jsTimestamp, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(jsTimestamp), zoneId);
    }

    public static ZonedDateTime toZonedDateTime(long jsTimestamp) {
        return JavetDateTimeUtils.toZonedDateTime(jsTimestamp, ZoneId.systemDefault());
    }
}

