/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.tasks.gw7;

import com.ca.apim.gateway.cagatewayconfig.tasks.gw7.PackageBuildException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;

public class GW7Builder {
    public static final GW7Builder INSTANCE = new GW7Builder();

    public void buildPackage(OutputStream gw7FileOutputStream, Set<PackageFile> packageFiles) {
        try (TarArchiveOutputStream taos = this.getTarOutputStream(gw7FileOutputStream);){
            this.writeFiles(taos, packageFiles);
        }
        catch (IOException e) {
            throw new PackageBuildException("Error building GW7 Package: " + e.getMessage(), e);
        }
    }

    private TarArchiveOutputStream getTarOutputStream(OutputStream gw7FileOutputStream) throws IOException {
        TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(gw7FileOutputStream));
        tarArchiveOutputStream.setLongFileMode(2);
        return tarArchiveOutputStream;
    }

    private void writeFiles(TarArchiveOutputStream taos, Set<PackageFile> packageFiles) {
        for (PackageFile file : packageFiles) {
            try {
                InputStream inputStream = (InputStream)file.fileStreamSupplier.get();
                Throwable throwable = null;
                try {
                    TarArchiveEntry tarEntry = new TarArchiveEntry(file.filePath);
                    tarEntry.setSize(file.fileSize);
                    if (file.executable) {
                        tarEntry.setMode(365);
                    }
                    taos.putArchiveEntry((ArchiveEntry)tarEntry);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)taos);
                    taos.closeArchiveEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new PackageBuildException("Error building GW7 Package. Error adding file: " + file.filePath + " Message: " + e.getMessage(), e);
            }
        }
    }

    public static class PackageFile {
        private final String filePath;
        private final long fileSize;
        private final Supplier<InputStream> fileStreamSupplier;
        private final boolean executable;

        public PackageFile(String filePath, long fileSize, Supplier<InputStream> fileStreamSupplier) {
            this(filePath, fileSize, fileStreamSupplier, false);
        }

        public PackageFile(String filePath, long fileSize, Supplier<InputStream> fileStreamSupplier, boolean executable) {
            this.filePath = filePath;
            this.fileSize = fileSize;
            this.fileStreamSupplier = fileStreamSupplier;
            this.executable = executable;
        }
    }
}

