/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ProjectDependencyUtils {
    private static final String AAR = ".aar";
    private static final String JAR = ".jar";

    private ProjectDependencyUtils() {
    }

    public static LinkedList<File> filterBundleFiles(Collection<File> files) {
        return ProjectDependencyUtils.filter(files, ".bundle", LinkedList::new);
    }

    public static Set<File> filterModularAssertionFiles(Collection<File> files) {
        return ProjectDependencyUtils.filter(files, AAR, LinkedHashSet::new);
    }

    public static Set<File> filterJarFiles(Collection<File> files) {
        return ProjectDependencyUtils.filter(files, JAR, LinkedHashSet::new);
    }

    @NotNull
    private static <C extends Collection<File>> C filter(Collection<File> files, String filter, Supplier<C> collectionFactory) {
        return (C)((Collection)files.stream().filter(f -> f.getName().endsWith(filter)).collect(Collectors.toCollection(collectionFactory)));
    }
}

