/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig;

import com.ca.apim.gateway.cagatewayconfig.BuildDeploymentBundleTask;
import com.ca.apim.gateway.cagatewayconfig.BuildEnvironmentBundleTask;
import com.ca.apim.gateway.cagatewayconfig.BuildFullBundleTask;
import com.ca.apim.gateway.cagatewayconfig.CAGatewayDeveloperBase;
import com.ca.apim.gateway.cagatewayconfig.EnvironmentConfig;
import com.ca.apim.gateway.cagatewayconfig.GatewayDeveloperPluginConfig;
import com.ca.apim.gateway.cagatewayconfig.tasks.gw7.PackageTask;
import java.io.File;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

public class CAGatewayDeveloper
implements Plugin<Project> {
    private static final String BUNDLE_CONFIGURATION = "bundle";
    private static final String MODULAR_ASSERTION_CONFIGURATION = "assertion";
    private static final String CUSTOM_ASSERTION_CONFIGURATION = "customassertion";
    private static final String BUNDLE_FILE_EXTENSION = "bundle";
    private static final String BUILT_BUNDLE_DIRECTORY = "bundle";
    private static final String GATEWAY_BUILD_DIRECTORY = "gateway";
    private static final String ENV_APPLICATION_CONFIGURATION = "environment-creator-application";
    private static final String BUILD_ENVIRONMENT_BUNDLE = "build-environment-bundle";
    private static final String BUILD_FULL_BUNDLE = "build-full-bundle";

    public void apply(@NotNull Project project) {
        project.getPlugins().apply(CAGatewayDeveloperBase.class);
        project.getPlugins().apply("base");
        GatewayDeveloperPluginConfig pluginConfig = CAGatewayDeveloper.createPluginConfig(project);
        CAGatewayDeveloper.createConfiguration(project, "bundle");
        CAGatewayDeveloper.createConfiguration(project, MODULAR_ASSERTION_CONFIGURATION);
        CAGatewayDeveloper.createConfiguration(project, CUSTOM_ASSERTION_CONFIGURATION);
        CAGatewayDeveloper.configureEnvironmentApplication(project);
        BuildDeploymentBundleTask buildDeploymentBundleTask = CAGatewayDeveloper.createBuildDeploymentBundleTask(project, pluginConfig);
        BuildEnvironmentBundleTask buildEnvironmentBundleTask = CAGatewayDeveloper.createBuildEnvironmentBundleTask(project, pluginConfig);
        BuildFullBundleTask buildFullBundleTask = CAGatewayDeveloper.createBuildFullBundleTask(project, pluginConfig, buildDeploymentBundleTask);
        PackageTask packageGW7Task = CAGatewayDeveloper.createPackageTask(project, pluginConfig, buildDeploymentBundleTask);
        CAGatewayDeveloper.configureGeneratedArtifacts(project, pluginConfig, buildDeploymentBundleTask, buildEnvironmentBundleTask, buildFullBundleTask, packageGW7Task);
    }

    @NotNull
    private static GatewayDeveloperPluginConfig createPluginConfig(@NotNull Project project) {
        EnvironmentConfig environmentConfig = (EnvironmentConfig)project.getExtensions().create("EnvironmentConfig", EnvironmentConfig.class, new Object[]{project});
        GatewayDeveloperPluginConfig pluginConfig = (GatewayDeveloperPluginConfig)project.getExtensions().create("GatewaySourceConfig", GatewayDeveloperPluginConfig.class, new Object[]{project, environmentConfig});
        project.afterEvaluate(p -> CAGatewayDeveloper.setDefaults(pluginConfig, environmentConfig, project));
        return pluginConfig;
    }

    private static void configureEnvironmentApplication(@NotNull Project project) {
        project.getConfigurations().create(ENV_APPLICATION_CONFIGURATION);
        String version = CAGatewayDeveloper.class.getPackage().getImplementationVersion();
        project.getDependencies().add(ENV_APPLICATION_CONFIGURATION, (Object)("com.ca.apim.gateway:environment-creator-application:" + (version != null ? version : "+")));
    }

    @NotNull
    private static BuildDeploymentBundleTask createBuildDeploymentBundleTask(@NotNull Project project, GatewayDeveloperPluginConfig pluginConfig) {
        return (BuildDeploymentBundleTask)project.getTasks().create("build-bundle", BuildDeploymentBundleTask.class, t -> {
            t.dependsOn(new Object[]{project.getConfigurations().getByName("bundle")});
            t.getFrom().set((Provider)new DefaultProvider(() -> {
                Directory dir = (Directory)pluginConfig.getSolutionDir().get();
                return dir.getAsFile().exists() ? dir : null;
            }));
            t.getInto().set((Provider)pluginConfig.getBuiltBundleDir());
            t.getTargetFolderPath().set(pluginConfig.getTargetFolderPath());
            t.getDependencies().setFrom((Iterable)project.getConfigurations().getByName("bundle"));
        });
    }

    @NotNull
    private static BuildEnvironmentBundleTask createBuildEnvironmentBundleTask(@NotNull Project project, GatewayDeveloperPluginConfig pluginConfig) {
        BuildEnvironmentBundleTask buildEnvironmentBundleTask = (BuildEnvironmentBundleTask)project.getTasks().create(BUILD_ENVIRONMENT_BUNDLE, BuildEnvironmentBundleTask.class, t -> {
            t.getInto().set((Provider)pluginConfig.getBuiltEnvironmentBundleDir());
            t.getEnvConfig().set(pluginConfig.getEnvConfig().getMap());
            t.getEnvironmentConfig().set(pluginConfig.getEnvironmentConfig());
            t.getConfigFolder().set((Provider)new DefaultProvider(() -> {
                Directory dir = (Directory)pluginConfig.getEnvConfig().getIncludeFolder().getOrNull();
                return dir != null ? (dir.getAsFile().exists() ? dir : null) : null;
            }));
            t.getConfigName().set(pluginConfig.getEnvConfig().getName());
        });
        return buildEnvironmentBundleTask;
    }

    private static BuildFullBundleTask createBuildFullBundleTask(@NotNull Project project, GatewayDeveloperPluginConfig pluginConfig, BuildDeploymentBundleTask buildDeploymentBundleTask) {
        BuildFullBundleTask buildFullBundleTask = (BuildFullBundleTask)project.getTasks().create(BUILD_FULL_BUNDLE, BuildFullBundleTask.class, t -> {
            t.getEnvConfig().set(pluginConfig.getEnvConfig().getMap());
            t.getEnvironmentConfig().set(pluginConfig.getEnvironmentConfig());
            t.getDependencyBundles().setFrom((Iterable)project.getConfigurations().getByName("bundle"));
            t.getDetemplatizeDeploymentBundles().set(pluginConfig.getDetemplatizeDeploymentBundles().getOrElse((Object)true));
            t.getInto().set((Provider)pluginConfig.getBuiltEnvironmentBundleDir());
            t.getConfigFolder().set((Provider)new DefaultProvider(() -> {
                Directory dir = (Directory)pluginConfig.getEnvConfig().getIncludeFolder().getOrNull();
                return dir != null ? (dir.getAsFile().exists() ? dir : null) : null;
            }));
            t.getConfigName().set(pluginConfig.getEnvConfig().getName());
        });
        buildFullBundleTask.dependsOn(new Object[]{buildDeploymentBundleTask});
        return buildFullBundleTask;
    }

    @NotNull
    private static PackageTask createPackageTask(@NotNull Project project, GatewayDeveloperPluginConfig pluginConfig, BuildDeploymentBundleTask buildDeploymentBundleTask) {
        return (PackageTask)project.getTasks().create("package-gw7", PackageTask.class, t -> {
            t.dependsOn(new Object[]{buildDeploymentBundleTask});
            t.getInto().set((Provider)new DefaultProvider(() -> () -> new File(new File(project.getBuildDir(), GATEWAY_BUILD_DIRECTORY), CAGatewayDeveloper.getBuiltArtifactName(project, "", "gw7"))));
            t.getBundle().set(pluginConfig.getBuiltBundleDir().file((Provider)new DefaultProvider(() -> CAGatewayDeveloper.getBuiltArtifactName(project, ".install", "bundle"))));
            t.getDependencyBundles().setFrom((Iterable)project.getConfigurations().getByName("bundle"));
            t.getContainerApplicationDependencies().setFrom((Iterable)project.getConfigurations().getByName(ENV_APPLICATION_CONFIGURATION));
            t.getDependencyModularAssertions().setFrom((Iterable)project.getConfigurations().getByName(MODULAR_ASSERTION_CONFIGURATION));
            t.getDependencyCustomAssertions().setFrom((Iterable)project.getConfigurations().getByName(CUSTOM_ASSERTION_CONFIGURATION));
        });
    }

    private static void configureGeneratedArtifacts(@NotNull Project project, GatewayDeveloperPluginConfig pluginConfig, BuildDeploymentBundleTask buildDeploymentBundleTask, BuildEnvironmentBundleTask buildEnvironmentBundleTask, BuildFullBundleTask buildFullBundleTask, PackageTask packageGW7Task) {
        project.afterEvaluate(p -> project.getTasks().getByPath("build").dependsOn(new Object[]{buildDeploymentBundleTask, packageGW7Task}));
        project.artifacts(artifactHandler -> CAGatewayDeveloper.addBundleArtifact(artifactHandler, (Provider<RegularFile>)packageGW7Task.getBundle(), (Task)buildDeploymentBundleTask, () -> ((Project)project).getName(), "deployment"));
        String artifactName = CAGatewayDeveloper.getBuiltArtifactName(project, "-env.install", "bundle");
        if (project.getGradle().getStartParameter().getTaskNames().contains(BUILD_ENVIRONMENT_BUNDLE)) {
            project.artifacts(artifactHandler -> CAGatewayDeveloper.addBundleArtifact(artifactHandler, (Provider<RegularFile>)pluginConfig.getBuiltBundleDir().file((Provider)new DefaultProvider(() -> artifactName)), (Task)buildEnvironmentBundleTask, () -> ((Project)project).getName(), "environment"));
        }
        String fullBundleArtifactName = CAGatewayDeveloper.getBuiltArtifactName(project, "-full.install", "bundle");
        if (project.getGradle().getStartParameter().getTaskNames().contains(BUILD_FULL_BUNDLE)) {
            project.artifacts(artifactHandler -> CAGatewayDeveloper.addBundleArtifact(artifactHandler, (Provider<RegularFile>)pluginConfig.getBuiltBundleDir().file((Provider)new DefaultProvider(() -> fullBundleArtifactName)), (Task)buildFullBundleTask, () -> ((Project)project).getName(), "full"));
        }
        project.afterEvaluate(p -> project.getExtensions().add("deployment-bundle-file", (Object)new File((File)buildDeploymentBundleTask.getInto().getAsFile().get(), CAGatewayDeveloper.getBuiltArtifactName(project, "-policy.install", "bundle")).toString()));
        project.afterEvaluate(p -> project.getExtensions().add("environment-bundle-file", (Object)new File((File)buildEnvironmentBundleTask.getInto().getAsFile().get(), artifactName).toString()));
        project.afterEvaluate(p -> project.getExtensions().add("full-bundle-file", (Object)new File((File)buildFullBundleTask.getInto().getAsFile().get(), fullBundleArtifactName).toString()));
    }

    private static void addBundleArtifact(ArtifactHandler artifactHandler, Provider<RegularFile> bundle, Task generatedTask, Supplier<String> nameSupplier, String classifier) {
        artifactHandler.add("default", (Object)new LazyPublishArtifact(bundle, null){

            public String getType() {
                return "bundle";
            }
        }, configurablePublishArtifact -> {
            configurablePublishArtifact.builtBy(new Object[]{generatedTask});
            configurablePublishArtifact.setExtension("bundle");
            configurablePublishArtifact.setName((String)nameSupplier.get());
            configurablePublishArtifact.setType("bundle");
            configurablePublishArtifact.setClassifier(classifier);
        });
    }

    private static void createConfiguration(Project project, String configurationName) {
        Configuration configuration = (Configuration)project.getConfigurations().create(configurationName);
        project.getConfigurations().getByName("default").extendsFrom(new Configuration[]{configuration});
    }

    @NotNull
    private static String getBuiltArtifactName(@NotNull Project project, String classifier, String bundleRequiredFileExtension) {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)project.getVersion().toString().trim(), (CharSequence[])new CharSequence[]{"", "unspecified"})) {
            return project.getName() + classifier + "." + bundleRequiredFileExtension;
        }
        return project.getName() + '-' + project.getVersion() + classifier + "." + bundleRequiredFileExtension;
    }

    private static void setDefaults(GatewayDeveloperPluginConfig pluginConfig, EnvironmentConfig environmentConfig, Project project) {
        if (!pluginConfig.getSolutionDir().isPresent()) {
            pluginConfig.getSolutionDir().set(new File(project.getProjectDir(), "src/main/gateway"));
        }
        File defaultBuildDir = new File(new File(project.getBuildDir(), GATEWAY_BUILD_DIRECTORY), "bundle");
        if (!pluginConfig.getBuiltBundleDir().isPresent()) {
            pluginConfig.getBuiltBundleDir().set(defaultBuildDir);
        }
        if (!pluginConfig.getBuiltEnvironmentBundleDir().isPresent()) {
            pluginConfig.getBuiltEnvironmentBundleDir().set(defaultBuildDir);
        }
        if (!environmentConfig.getName().isPresent()) {
            environmentConfig.getName().set((Object)"");
        }
    }
}

