/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig;

import com.ca.apim.gateway.cagatewayconfig.ProjectDependencyUtils;
import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.environment.FullBundleCreator;
import com.ca.apim.gateway.cagatewayconfig.environment.MissingEnvironmentException;
import com.ca.apim.gateway.cagatewayconfig.util.environment.EnvironmentConfigurationUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class BuildFullBundleTask
extends DefaultTask {
    private final EnvironmentConfigurationUtils environmentConfigurationUtils = (EnvironmentConfigurationUtils)InjectionRegistry.getInstance(EnvironmentConfigurationUtils.class);
    private final Property<Map> environmentConfig = this.getProject().getObjects().property(Map.class);
    private final ConfigurableFileCollection dependencyBundles;
    private final DirectoryProperty into;
    private final Property<Boolean> detemplatizeDeploymentBundles;
    private final DirectoryProperty configFolder;
    private final Property<String> configName;
    private final Property<Map> envConfig = this.getProject().getObjects().property(Map.class);

    @Inject
    public BuildFullBundleTask() {
        this.dependencyBundles = this.getProject().files(new Object[0]);
        this.into = this.newOutputDirectory();
        this.detemplatizeDeploymentBundles = this.getProject().getObjects().property(Boolean.class);
        this.configFolder = this.newInputDirectory();
        this.configName = this.getProject().getObjects().property(String.class);
    }

    @InputFiles
    ConfigurableFileCollection getDependencyBundles() {
        return this.dependencyBundles;
    }

    @OutputDirectory
    DirectoryProperty getInto() {
        return this.into;
    }

    @Input
    @Optional
    Property<Map> getEnvironmentConfig() {
        return this.environmentConfig;
    }

    @Input
    @Optional
    Property<Map> getEnvConfig() {
        return this.envConfig;
    }

    @Input
    Property<Boolean> getDetemplatizeDeploymentBundles() {
        return this.detemplatizeDeploymentBundles;
    }

    @InputDirectory
    @Optional
    DirectoryProperty getConfigFolder() {
        return this.configFolder;
    }

    @Input
    @Optional
    Property<String> getConfigName() {
        return this.configName;
    }

    @TaskAction
    public void perform() {
        FullBundleCreator fullBundleCreator = (FullBundleCreator)InjectionRegistry.getInstance(FullBundleCreator.class);
        String bundleDirectory = ((File)this.into.getAsFile().get()).getPath();
        String configurationName = this.configName != null ? BuilderUtils.removeAllSpecialChars((String)((String)this.configName.get())) : "";
        ProjectInfo projectInfo = new ProjectInfo(this.getProject().getName(), this.getProject().getGroup().toString(), this.getProject().getVersion().toString(), configurationName);
        List metaDataFiles = FileUtils.collectFiles((String)bundleDirectory, (String)JsonFileUtils.METADATA_FILE_NAME_SUFFIX);
        if (metaDataFiles.isEmpty()) {
            throw new MissingEnvironmentException("Metadata file does not exist.");
        }
        File configuredFolder = (File)this.configFolder.getAsFile().getOrNull();
        Map environmentEntities = (Map)java.util.Optional.ofNullable(this.envConfig.getOrNull()).orElse(this.environmentConfig.getOrNull());
        metaDataFiles.stream().forEach(metaDataFile -> {
            Pair bundleEnvironmentValues = this.environmentConfigurationUtils.parseBundleMetadata(metaDataFile, configuredFolder);
            if (null != bundleEnvironmentValues) {
                String fullInstallBundleFilename = (String)bundleEnvironmentValues.getLeft() + "-full" + ".install.bundle";
                if (environmentEntities != null) {
                    ((Map)bundleEnvironmentValues.getRight()).putAll(this.environmentConfigurationUtils.parseEnvironmentValues(environmentEntities));
                }
                fullBundleCreator.createFullBundle(bundleEnvironmentValues, ProjectDependencyUtils.filterBundleFiles(this.dependencyBundles.getAsFileTree().getFiles()), bundleDirectory, projectInfo, fullInstallBundleFilename, configuredFolder != null ? configuredFolder.getPath() : "", ((Boolean)this.detemplatizeDeploymentBundles.get()).booleanValue());
            }
        });
    }
}

