/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleCreationMode;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleCreator;
import com.ca.apim.gateway.cagatewayconfig.environment.MissingEnvironmentException;
import com.ca.apim.gateway.cagatewayconfig.util.environment.EnvironmentConfigurationUtils;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class BuildEnvironmentBundleTask
extends DefaultTask {
    private final DirectoryProperty into = this.newOutputDirectory();
    private final EnvironmentConfigurationUtils environmentConfigurationUtils;
    private final DirectoryProperty configFolder;
    private final Property<String> configName;
    private final Property<Map> environmentConfig = this.getProject().getObjects().property(Map.class);
    private final Property<Map> envConfig = this.getProject().getObjects().property(Map.class);

    @Inject
    public BuildEnvironmentBundleTask() {
        this.environmentConfigurationUtils = (EnvironmentConfigurationUtils)InjectionRegistry.getInstance(EnvironmentConfigurationUtils.class);
        this.configFolder = this.newInputDirectory();
        this.configName = this.getProject().getObjects().property(String.class);
    }

    @OutputDirectory
    DirectoryProperty getInto() {
        return this.into;
    }

    @Input
    @Optional
    Property<Map> getEnvironmentConfig() {
        return this.environmentConfig;
    }

    @Input
    @Optional
    Property<Map> getEnvConfig() {
        return this.envConfig;
    }

    @InputDirectory
    @Optional
    DirectoryProperty getConfigFolder() {
        return this.configFolder;
    }

    @Input
    @Optional
    Property<String> getConfigName() {
        return this.configName;
    }

    @TaskAction
    public void perform() {
        EnvironmentBundleCreator environmentBundleCreator = (EnvironmentBundleCreator)InjectionRegistry.getInstance(EnvironmentBundleCreator.class);
        File configuredFolder = (File)this.configFolder.getAsFile().getOrNull();
        Map environmentEntities = (Map)java.util.Optional.ofNullable(this.envConfig.getOrNull()).orElse(this.environmentConfig.getOrNull());
        if (configuredFolder == null && environmentEntities == null) {
            throw new MissingEnvironmentException("EnvironmentConfig is not configured");
        }
        Map bundleEnvironmentValues = new HashMap();
        if (configuredFolder != null) {
            bundleEnvironmentValues = this.environmentConfigurationUtils.loadConfigFolder(configuredFolder);
        }
        String configurationName = this.configName != null ? BuilderUtils.removeAllSpecialChars((String)((String)this.configName.get())) : "";
        ProjectInfo projectInfo = new ProjectInfo(this.getProject().getName(), this.getProject().getGroup().toString(), this.getProject().getVersion().toString(), configurationName);
        String envBundleFileName = this.getEnvBundleFilename(projectInfo);
        if (environmentEntities != null) {
            bundleEnvironmentValues.putAll(this.environmentConfigurationUtils.parseEnvironmentValues(environmentEntities));
        }
        environmentBundleCreator.createEnvironmentBundle(bundleEnvironmentValues, ((File)this.into.getAsFile().get()).getPath(), ((File)this.into.getAsFile().get()).getPath(), configuredFolder != null ? configuredFolder.getPath() : "", EnvironmentBundleCreationMode.PLUGIN, envBundleFileName, projectInfo);
    }

    private String getEnvBundleFilename(ProjectInfo projectInfo) {
        StringBuilder bundleNameBuilder = new StringBuilder(projectInfo.getName());
        bundleNameBuilder.append("-").append("environment");
        if (StringUtils.isNotBlank((CharSequence)projectInfo.getVersion())) {
            bundleNameBuilder.append("-").append(projectInfo.getVersion());
            if (StringUtils.isNotBlank((CharSequence)projectInfo.getConfigName())) {
                bundleNameBuilder.append("-").append(projectInfo.getConfigName());
            }
        }
        return bundleNameBuilder.append(".install.bundle").toString();
    }
}

