/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayimport;

import com.ca.apim.gateway.cagatewayimport.CAGatewayImportBase;
import com.ca.apim.gateway.cagatewayimport.config.GatewayImportConfig;
import com.ca.apim.gateway.cagatewayimport.config.GatewayImportConnectionProperties;
import com.ca.apim.gateway.cagatewayimport.tasks.ImportBundleTask;
import java.util.function.Supplier;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

public class CAGatewayImport
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        project.getPlugins().apply(CAGatewayImportBase.class);
        project.getPlugins().apply("base");
        GatewayImportConnectionProperties gatewayConnectionProperties = (GatewayImportConnectionProperties)project.getExtensions().create("GatewayImportConnection", GatewayImportConnectionProperties.class, new Object[]{project});
        GatewayImportConfig gatewayImportConfig = (GatewayImportConfig)project.getExtensions().create("GatewayImportConfig", GatewayImportConfig.class, new Object[]{project});
        project.afterEvaluate(p -> CAGatewayImport.setDefaults(gatewayConnectionProperties));
        project.getTasks().create("import-bundle", ImportBundleTask.class, t -> {
            t.setGatewayConnectionProperties(gatewayConnectionProperties);
            t.setGatewayImportConfig(gatewayImportConfig);
        });
    }

    private static void setDefaults(GatewayImportConnectionProperties gatewayConnectionProperties) {
        CAGatewayImport.setDefault(gatewayConnectionProperties.getUrl(), () -> "https://localhost:8443/restman");
        CAGatewayImport.setDefault(gatewayConnectionProperties.getUserName(), () -> "admin");
        CAGatewayImport.setDefault(gatewayConnectionProperties.getUserPass(), () -> "password");
    }

    private static <T> void setDefault(Property<T> property, Supplier<T> supplier) {
        if (!property.isPresent()) {
            property.set(supplier.get());
        }
    }
}

