/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProvider;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyAssertionSimplifier;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierContext;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class SpecificUserAssertionSimplifier
implements PolicyAssertionSimplifier {
    private static final Logger LOGGER = Logger.getLogger(SpecificUserAssertionSimplifier.class.getName());

    @Override
    public void simplifyAssertionElement(PolicySimplifierContext context) throws DocumentParseException {
        Element specificUserAssertionElement = context.getAssertionElement();
        Bundle bundle = context.getBundle();
        Element idProviderGoidElement = DocumentUtils.getSingleElement((Element)specificUserAssertionElement, (String)"L7p:IdentityProviderOid");
        String idProviderGoid = idProviderGoidElement.getAttribute("goidValue");
        Optional<IdentityProvider> idProv = bundle.getEntities(IdentityProvider.class).values().stream().filter(e -> e.getId().equals(idProviderGoid)).findAny();
        if (idProv.isPresent()) {
            SpecificUserAssertionSimplifier.updateSpecificUserAssertionElement(specificUserAssertionElement, idProviderGoidElement, idProv.get().getName());
        } else if ("0000000000000000fffffffffffffffe".equals(idProviderGoid)) {
            SpecificUserAssertionSimplifier.updateSpecificUserAssertionElement(specificUserAssertionElement, idProviderGoidElement, "Internal Identity Provider");
        } else {
            LOGGER.log(Level.WARNING, "Could not find referenced identity provider with id: {0}", idProviderGoid);
        }
    }

    private static void updateSpecificUserAssertionElement(Element specificUserAssertionElement, Element goidElementToRemove, String internalIdpName) {
        Node firstChild = specificUserAssertionElement.getFirstChild();
        Element idProviderNameElement = DocumentUtils.createElementWithAttribute((Document)specificUserAssertionElement.getOwnerDocument(), (String)"L7p:IdentityProviderName", (String)"stringValue", (String)internalIdpName);
        if (firstChild != null) {
            specificUserAssertionElement.insertBefore(idProviderNameElement, firstChild);
        } else {
            specificUserAssertionElement.appendChild(idProviderNameElement);
        }
        specificUserAssertionElement.removeChild(goidElementToRemove);
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:SpecificUser";
    }
}

