/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.JmsDestination;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyAssertionSimplifier;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierContext;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class JmsRoutingAssertionSimplifier
implements PolicyAssertionSimplifier {
    private static final Logger LOGGER = Logger.getLogger(JmsRoutingAssertionSimplifier.class.getName());

    @Override
    public void simplifyAssertionElement(PolicySimplifierContext context) throws DocumentParseException {
        Bundle bundle = context.getBundle();
        Element jmsRoutingAssertionElement = context.getAssertionElement();
        Element jmsEndpointGoidEle = DocumentUtils.getSingleElement((Element)jmsRoutingAssertionElement, (String)"L7p:EndpointOid");
        String jmsEndpointGoid = jmsEndpointGoidEle.getAttribute("goidValue");
        Optional<JmsDestination> jmsDestination = bundle.getEntities(JmsDestination.class).values().stream().filter(e -> e.getId().equals(jmsEndpointGoid)).findAny();
        if (!jmsDestination.isPresent()) {
            LOGGER.log(Level.WARNING, "Could not find referenced JMS Destination with id: {0}", jmsEndpointGoid);
        }
        jmsRoutingAssertionElement.removeChild(jmsEndpointGoidEle);
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:JmsRoutingAssertion";
    }
}

