/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.MissingGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyAssertionSimplifier;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierContext;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class IncludeAssertionSimplifier
implements PolicyAssertionSimplifier {
    private static final Logger LOGGER = Logger.getLogger(IncludeAssertionSimplifier.class.getName());

    @Override
    public void simplifyAssertionElement(PolicySimplifierContext context) throws DocumentParseException {
        Element assertionElement = context.getAssertionElement();
        Bundle bundle = context.getBundle();
        Bundle resultantBundle = context.getResultantBundle();
        Element policyGuidElement = DocumentUtils.getSingleElement((Element)assertionElement, (String)"L7p:PolicyGuid");
        String includedPolicyGuid = policyGuidElement.getAttribute("stringValue");
        Optional<Policy> resultantPolicyEntity = resultantBundle.getEntities(Policy.class).values().stream().filter(p -> includedPolicyGuid.equals(p.getGuid())).findAny();
        if (resultantPolicyEntity.isPresent()) {
            policyGuidElement.setAttribute("policyPath", this.getPolicyPath(bundle, resultantPolicyEntity.get()));
            policyGuidElement.removeAttribute("stringValue");
        } else {
            boolean excluded = true;
            Optional<Policy> policyEntity = bundle.getEntities(Policy.class).values().stream().filter(p -> includedPolicyGuid.equals(p.getGuid())).findAny();
            if (!policyEntity.isPresent()) {
                LOGGER.log(Level.WARNING, "Could not find referenced policy include with guid: {0}", includedPolicyGuid);
                excluded = false;
            }
            MissingGatewayEntity missingEntity = new MissingGatewayEntity();
            missingEntity.setType("POLICY");
            missingEntity.setName(policyEntity.isPresent() ? this.getPolicyPath(bundle, policyEntity.get()) : "Policy#" + includedPolicyGuid);
            missingEntity.setGuid(includedPolicyGuid);
            missingEntity.setExcluded(excluded);
            missingEntity.setId(policyEntity.isPresent() ? policyEntity.get().getId() : missingEntity.getGuid().replace("-", ""));
            context.getResultantBundle().addEntity((GatewayEntity)missingEntity);
            LOGGER.log(Level.WARNING, "Recording the referenced policy include with guid: {0} as {1} entity", new Object[]{includedPolicyGuid, excluded ? "excluded" : "missing"});
            policyGuidElement.setAttribute("policyPath", missingEntity.getName());
            policyGuidElement.removeAttribute("stringValue");
        }
    }

    private String getPolicyPath(Bundle bundle, Policy policyEntity) {
        Folder folder = bundle.getFolderTree().getFolderById(policyEntity.getParentFolder().getId());
        Path folderPath = bundle.getFolderTree().getPath(folder);
        return PathUtils.unixPath((String)folderPath.toString(), (String[])new String[]{policyEntity.getName()});
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:Include";
    }
}

