/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.sanitize;

import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.inject.Inject;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class SanitizeBundleTask
extends DefaultTask {
    private final Transformer transformer;
    private RegularFileProperty inputBundleFile = this.newInputFile();
    private RegularFileProperty outputBundleFile = this.newOutputFile();

    @Inject
    public SanitizeBundleTask() {
        this(DocumentTools.INSTANCE);
    }

    private SanitizeBundleTask(DocumentTools documentTools) {
        StreamSource stylesheet = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("/sanitize-bundle.xsl"));
        this.transformer = documentTools.getTransformer(stylesheet);
    }

    @InputFile
    public RegularFileProperty getInputBundleFile() {
        return this.inputBundleFile;
    }

    @OutputFile
    public RegularFileProperty getOutputBundleFile() {
        return this.outputBundleFile;
    }

    @TaskAction
    public void perform() throws TransformerException, FileNotFoundException {
        StreamSource source = new StreamSource((File)this.inputBundleFile.getAsFile().get());
        StreamResult streamResult = new StreamResult(new FileOutputStream((File)this.outputBundleFile.getAsFile().get()));
        this.transformer.transform(source, streamResult);
    }
}

