/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.writer;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.EntityWriter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.WriteException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class UnsupportedEntityWriter
implements EntityWriter {
    private final DocumentFileUtils documentFileUtils;
    private final DocumentTools documentTools;

    @Inject
    public UnsupportedEntityWriter(DocumentFileUtils documentFileUtils, DocumentTools documentTools) {
        this.documentFileUtils = documentFileUtils;
        this.documentTools = documentTools;
    }

    @Override
    public void write(Bundle bundle, File rootFolder, Bundle rawBundle) {
        File configFolder = new File(rootFolder, "config");
        this.documentFileUtils.createFolder(configFolder.toPath());
        Map unsupportedGatewayEntityMap = bundle.getUnsupportedEntities();
        if (!unsupportedGatewayEntityMap.isEmpty()) {
            DocumentBuilder builder = this.documentTools.getDocumentBuilder();
            Document document = builder.newDocument();
            Element items = document.createElement("l7:Items");
            unsupportedGatewayEntityMap.values().parallelStream().forEach(unsupportedGatewayEntity -> {
                Node item = unsupportedGatewayEntity.getElement().cloneNode(true);
                document.adoptNode(item);
                items.appendChild(item);
            });
            items.setAttribute("xmlns:l7", "http://ns.l7tech.com/2010/04/gateway-management");
            this.writeElement(configFolder, items);
        }
    }

    private void writeElement(File configFolder, Element items) {
        Path unsupportedEntitiesFilePath = configFolder.toPath().resolve("unsupported-entities.xml");
        try (InputStream itemStream = IOUtils.toInputStream((String)this.documentTools.elementToString(items), (Charset)StandardCharsets.UTF_8);){
            FileUtils.copyInputStreamToFile((InputStream)itemStream, (File)unsupportedEntitiesFilePath.toFile());
        }
        catch (IOException e) {
            throw new WriteException("Unable to write unsupported entities to xml file", e);
        }
    }
}

