/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.writer;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.beans.SoapResource;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.EntityWriter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.WriteException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Singleton
public class SoapResourceWriter
implements EntityWriter {
    private final DocumentFileUtils documentFileUtils;

    @Inject
    SoapResourceWriter(DocumentFileUtils documentFileUtils) {
        this.documentFileUtils = documentFileUtils;
    }

    @Override
    public void write(Bundle bundle, File rootFolder, Bundle rawBundle) {
        Map services = bundle.getEntities(Service.class);
        services.values().stream().filter(s -> CollectionUtils.isNotEmpty((Collection)s.getSoapResources())).forEach(serviceEntity -> serviceEntity.getSoapResources().forEach(resource -> this.writeSoapResource(bundle, rootFolder, serviceEntity.getParentFolder().getId(), serviceEntity.getName(), (SoapResource)resource)));
    }

    private void writeSoapResource(Bundle bundle, File rootFolder, String folderId, String name, SoapResource resource) {
        File wsdlFolder = new File(rootFolder, "soapResources");
        this.documentFileUtils.createFolder(wsdlFolder.toPath());
        Folder folder = bundle.getFolderTree().getFolderById(folderId);
        Path folderPath = wsdlFolder.toPath().resolve(bundle.getFolderTree().getPath(folder));
        folderPath = new File(folderPath.toFile(), name).toPath();
        this.documentFileUtils.createFolders(folderPath);
        Path policyPath = folderPath.resolve(resource.getBaseName() + resource.getExtensionByType());
        try (InputStream policyStream = IOUtils.toInputStream((String)resource.getContent(), (Charset)StandardCharsets.UTF_8);){
            FileUtils.copyInputStreamToFile((InputStream)policyStream, (File)policyPath.toFile());
        }
        catch (IOException e) {
            throw new WriteException("Unable to write wsdl to file", e);
        }
    }
}

