/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.writer;

import com.ca.apim.gateway.cagatewayconfig.beans.EntityTypeRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.EntityWriter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.WriterHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EntityWriterRegistry {
    private final Collection<EntityWriter> entityWriters;

    @Inject
    public EntityWriterRegistry(Set<EntityWriter> writers, DocumentFileUtils documentFileUtils, JsonTools jsonTools) {
        HashSet<EntityWriter> allWriters = new HashSet<EntityWriter>(writers);
        EntityTypeRegistry entityTypeRegistry = (EntityTypeRegistry)InjectionRegistry.getInstance(EntityTypeRegistry.class);
        entityTypeRegistry.getEntityTypeMap().values().forEach(info -> {
            if (info.getFileName() != null && info.getFileType() != null) {
                allWriters.add((bundle, rootFolder, rawBundle) -> WriterHelper.write(bundle, rootFolder, info, documentFileUtils, jsonTools));
            }
        });
        this.entityWriters = Collections.unmodifiableCollection(allWriters);
    }

    public Collection<EntityWriter> getEntityWriters() {
        return this.entityWriters;
    }
}

