/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.linker;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.ClusterProperty;
import com.ca.apim.gateway.cagatewayconfig.beans.Dependency;
import com.ca.apim.gateway.cagatewayconfig.beans.GlobalEnvironmentProperty;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntitiesLinker;
import com.ca.apim.gateway.cagatewayexport.util.properties.PropertyFileUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class ClusterPropertyLinker
implements EntitiesLinker {
    @Override
    public void link(Bundle filteredBundle, Bundle bundle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void link(Bundle filteredBundle, Bundle bundle, File rootFolder) {
        Map clusterPropertyMap = filteredBundle.getEntities(ClusterProperty.class);
        HashSet<String> idsToRemove = new HashSet<String>();
        File propertiesFile = new File(new File(rootFolder, "config"), "static.properties");
        Properties staticProperties = PropertyFileUtils.loadExistingProperties(propertiesFile);
        for (ClusterProperty clusterProperty : clusterPropertyMap.values()) {
            if (staticProperties.containsKey(clusterProperty.getName())) continue;
            GlobalEnvironmentProperty prop = new GlobalEnvironmentProperty(clusterProperty.getName(), clusterProperty.getValue());
            filteredBundle.getEntities(GlobalEnvironmentProperty.class).put(prop.getName(), prop);
            idsToRemove.add(clusterProperty.getId());
        }
        idsToRemove.forEach(clusterPropertyMap::remove);
    }

    @Override
    public void link(Set<Dependency> dependencies) {
        dependencies.stream().filter(entity -> "CLUSTER_PROPERTY".equals(entity.getType())).forEach(e -> e.setType("ENVIRONMENT_PROPERTY"));
    }
}

