/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.xml;

import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtilsException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentToolsException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentTools {
    public static final DocumentTools INSTANCE = new DocumentTools();
    private final DocumentBuilder builder;
    private final XPathFactory xPathFactory;
    private final TransformerFactory transformerFactory;

    public DocumentTools() {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DocumentToolsException("Unexpected exception creating DocumentBuilder", e);
        }
        this.xPathFactory = XPathFactory.newInstance();
        try {
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.transformerFactory.setAttribute("indent-number", 4);
        }
        catch (TransformerConfigurationException e) {
            throw new DocumentToolsException("Unexpected exception creating TransformerFactory", e);
        }
    }

    public Transformer getTransformer() {
        try {
            return this.configureTransformer(this.transformerFactory.newTransformer());
        }
        catch (TransformerConfigurationException e) {
            throw new DocumentToolsException("Exception loading stylesheet.", e);
        }
    }

    public Transformer getTransformer(StreamSource stylesheet) {
        try {
            return this.configureTransformer(this.transformerFactory.newTransformer(stylesheet));
        }
        catch (TransformerConfigurationException e) {
            throw new DocumentToolsException("Exception loading stylesheet.", e);
        }
    }

    private Transformer configureTransformer(Transformer transformer) {
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "yes");
        return transformer;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    public Document parse(File file) throws DocumentParseException {
        try {
            return this.parse(FileUtils.openInputStream((File)file));
        }
        catch (IOException e) {
            throw new DocumentParseException("Exception reading file: " + file, e);
        }
    }

    public Document parse(String string) throws DocumentParseException {
        try {
            return this.parse(IOUtils.toInputStream((String)string, (String)"UTF-8"));
        }
        catch (IOException e) {
            throw new DocumentParseException("Exception creating stream from a String", e);
        }
    }

    private synchronized Document parse(InputStream inputStream) throws DocumentParseException {
        try {
            return this.builder.parse(inputStream);
        }
        catch (IOException | SAXException e) {
            throw new DocumentParseException("Exception parsing document from input stream", e);
        }
    }

    private XPath newXPath() {
        return this.xPathFactory.newXPath();
    }

    public void cleanup(Document bundleDocument) {
        NodeList nodeList;
        bundleDocument.normalize();
        XPath xPath = this.newXPath();
        try {
            nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", bundleDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new DocumentToolsException("Unexpected error evaluating xpath.", e);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            node.getParentNode().removeChild(node);
        }
    }

    public String elementToString(Element element) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.printXML(element, byteArrayOutputStream, false);
        try {
            String string = byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new DocumentFileUtilsException("Error writing xml: " + e.getMessage(), e);
        }
        finally {
            com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils.closeQuietly(byteArrayOutputStream);
        }
    }

    public void printXML(Element node, OutputStream outStream, boolean addNamespace) {
        if (addNamespace) {
            node.setAttribute("xmlns:l7", "http://ns.l7tech.com/2010/04/gateway-management");
        }
        Transformer transformer = this.getTransformer();
        try (OutputStreamWriter writer = new OutputStreamWriter(outStream, StandardCharsets.UTF_8);){
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (IOException | TransformerException e) {
            throw new DocumentFileUtilsException("Exception writing xml element to stream.", e);
        }
    }
}

