/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.paths;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PathUtils {
    private static final String UNIX_PATH_SEPARATOR = "/";

    private PathUtils() {
    }

    public static String unixPath(@NotNull String first, String ... more) {
        return FilenameUtils.separatorsToUnix((String)Paths.get(first, more).toString());
    }

    public static String unixPath(@NotNull Path path) {
        return FilenameUtils.separatorsToUnix((String)path.toString());
    }

    @NotNull
    public static String unixPathEndingWithSeparator(@NotNull String first, String ... more) {
        return FilenameUtils.separatorsToUnix((String)Paths.get(first, more).toString()) + UNIX_PATH_SEPARATOR;
    }

    @NotNull
    public static String unixPathEndingWithSeparator(@NotNull Path path) {
        return FilenameUtils.separatorsToUnix((String)path.toString()) + UNIX_PATH_SEPARATOR;
    }

    public static String extractName(String nameWithPath) {
        int index = nameWithPath.lastIndexOf(UNIX_PATH_SEPARATOR);
        return index > -1 ? nameWithPath.substring(index + 1) : nameWithPath;
    }

    public static String extractPath(String nameWithPath) {
        int index = nameWithPath.lastIndexOf(UNIX_PATH_SEPARATOR);
        return index > -1 ? nameWithPath.substring(0, index + 1) : "";
    }

    public static String extractNameFromUniqueEntityName(String uniqueName) {
        String[] nameParts = StringUtils.split((String)uniqueName, (String)"::");
        if (nameParts.length >= 2) {
            return nameParts[1];
        }
        return StringUtils.remove((String)uniqueName, (String)"::");
    }
}

