/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.gateway;

import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BuilderUtils {
    private static final String DATE_VALUE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final Pattern REGEX_ALPHANUMERIC = Pattern.compile("[^A-Za-z0-9]");

    public static void buildAndAppendPropertiesElement(Map<String, Object> properties, Document document, Element elementToAppendInto) {
        if (MapUtils.isEmpty(properties)) {
            return;
        }
        elementToAppendInto.appendChild(BuilderUtils.buildPropertiesElement(properties, document));
    }

    public static Element buildPropertiesElement(Map<String, Object> properties, Document document) {
        return BuilderUtils.buildPropertiesElement(properties, document, "l7:Properties");
    }

    public static Element buildPropertiesElement(Map<String, Object> properties, Document document, String propertiesElementName) {
        Element propertiesElement = document.createElement(propertiesElementName);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getValue() == null) continue;
            propertiesElement.appendChild(BuilderUtils.createPropertyElement(document, entry.getKey(), entry.getValue()));
        }
        return propertiesElement;
    }

    @NotNull
    public static Element createPropertyElement(Document document, String key, Object value) {
        String elementType;
        Element propertyElement = document.createElement("l7:Property");
        propertyElement.setAttribute("key", key);
        String elementValue = value.toString();
        if (String.class.isAssignableFrom(value.getClass())) {
            elementType = "l7:StringValue";
        } else if (Integer.class.isAssignableFrom(value.getClass())) {
            elementType = "l7:IntegerValue";
        } else if (Long.class.isAssignableFrom(value.getClass())) {
            elementType = "l7:LongValue";
        } else if (Boolean.class.isAssignableFrom(value.getClass())) {
            elementType = "l7:BooleanValue";
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            elementType = "l7:DateValue";
            elementValue = DateFormatUtils.format((Date)((Date)value), (String)DATE_VALUE_PATTERN);
        } else {
            throw new EntityBuilderException("Could not create property (" + key + ") for value type: " + value.getClass().getTypeName());
        }
        Element valueElement = document.createElement(elementType);
        valueElement.setTextContent(elementValue);
        propertyElement.appendChild(valueElement);
        return propertyElement;
    }

    public static Map<String, Object> mapPropertiesElements(Element propertiesElement, String propertiesElementName) {
        if (propertiesElement == null) {
            return Collections.emptyMap();
        }
        if (!Objects.equals(propertiesElement.getNodeName(), propertiesElementName)) {
            throw new BundleLoadException("Current node is not " + propertiesElementName + " node, it is " + propertiesElement.getNodeName());
        }
        List<Element> properties = DocumentUtils.getChildElements(propertiesElement, "l7:Property");
        return properties.stream().collect(Collectors.toMap(s -> s.getAttribute("key"), o -> {
            String propKey = o.getAttribute("key");
            NodeList childNodes = o.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                return BuilderUtils.extractPropertyValue(propKey, (Element)child);
            }
            throw new BundleLoadException("Property " + propKey + " does not have a value");
        }));
    }

    public static String insertPrefixToEnvironmentVariable(String environmentVariable, String prefix) {
        StringBuilder stringBuilder = new StringBuilder(environmentVariable).insert("ENV.".length(), prefix + ".");
        return stringBuilder.toString();
    }

    private static Object extractPropertyValue(String key, Element valueElement) {
        switch (valueElement.getNodeName()) {
            case "l7:StringValue": {
                return valueElement.getTextContent();
            }
            case "l7:BooleanValue": {
                return BooleanUtils.toBoolean((String)valueElement.getTextContent());
            }
            case "l7:LongValue": {
                return Long.parseLong(valueElement.getTextContent());
            }
            case "l7:IntegerValue": 
            case "l7:IntValue": {
                return Integer.parseInt(valueElement.getTextContent());
            }
            case "l7:DateValue": {
                return BuilderUtils.parseDateFromString(key, valueElement.getTextContent());
            }
        }
        throw new BundleLoadException("Type of property " + key + " is " + valueElement.getNodeName() + " which is not yet supported");
    }

    @NotNull
    private static Date parseDateFromString(String key, String dateAsString) {
        try {
            return DateUtils.parseDateStrictly((String)dateAsString, (String[])new String[]{DATE_VALUE_PATTERN});
        }
        catch (ParseException e) {
            throw new EntityBuilderException("Unable to parse date property (" + key + ") value: " + dateAsString);
        }
    }

    public static String removeAllSpecialChars(String str) {
        return REGEX_ALPHANUMERIC.matcher(str).replaceAll("");
    }

    private BuilderUtils() {
    }
}

