/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.environment;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class CharacterBlacklist {
    public static final char LESS_THAN = '<';
    public static final char GREATER_THAN = '>';
    public static final char COLON = ':';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char FORWARD_SLASH = '/';
    public static final char BACK_SLASH = '\\';
    public static final char PIPE = '|';
    public static final char QUESTION_MARK = '?';
    public static final char ASTERISK = '*';
    public static final char NULL_CHAR = '\u0000';
    private static final Set<Character> charBlackList = CharacterBlacklist.initializeCharBlacklist();

    public static Set<Character> getCharBlacklist() {
        return charBlackList;
    }

    private static Set<Character> initializeCharBlacklist() {
        Field[] fields = CharacterBlacklist.class.getFields();
        HashSet<Character> charBlackList = new HashSet<Character>();
        Stream.of(fields).forEach(field -> {
            try {
                char fieldValue = ((Character)field.get(CharacterBlacklist.class)).charValue();
                charBlackList.add(Character.valueOf(fieldValue));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Error accessing blacklist character field " + field.getName(), e);
            }
        });
        return charBlackList;
    }

    private CharacterBlacklist() {
    }
}

