/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.connection;

import com.ca.apim.gateway.cagatewayconfig.util.connection.GatewayClientException;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.ConnectionUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;

public class GatewayClient {
    private static final String KEY_PASSPHRASE_HEADER = "L7-key-passphrase";
    private static final Logger LOGGER = Logger.getLogger(GatewayClient.class.getName());
    private static final SecureRandom RANDOM = new SecureRandom();
    public static final GatewayClient INSTANCE = new GatewayClient();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream makeGatewayAPICall(RequestBuilder requestBuilder, String userName, String password) {
        try (CloseableHttpClient client = GatewayClient.buildHTTPSClient(userName, password);){
            InputStream inputStream = GatewayClient.makeAPICall((HttpClient)client, requestBuilder);
            return inputStream;
        }
        catch (IOException e) {
            throw new GatewayClientException("Exception making API calls", e);
        }
    }

    private static InputStream makeAPICall(HttpClient client, RequestBuilder requestBuilder) throws IOException {
        InputStream responseStream;
        HttpResponse response;
        String encodedPassphrase = RandomStringUtils.random((int)64, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)RANDOM);
        requestBuilder.addHeader(KEY_PASSPHRASE_HEADER, Base64.getEncoder().encodeToString(encodedPassphrase.getBytes(Charset.defaultCharset())));
        HttpUriRequest request = requestBuilder.build();
        String uri = request.getURI().toString();
        try {
            response = client.execute(request);
        }
        catch (IOException e) {
            throw new GatewayClientException("Could not make an API Call (" + request.getMethod() + ") to: " + uri, e);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        LOGGER.log(Level.FINE, "Status code is: {0} for uri: {1}", new Object[]{statusCode, uri});
        try {
            responseStream = response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new GatewayClientException("Could not retrieve response body from API Call (" + request.getMethod() + ") to: " + uri, e);
        }
        byte[] responseBytes = IOUtils.toByteArray((InputStream)responseStream);
        if (200 != statusCode) {
            throw new GatewayClientException("API Call (" + request.getMethod() + ") to gateway returned status " + statusCode + " for uri: " + uri + "\nResponse:\n\n" + new String(responseBytes));
        }
        return new ByteArrayInputStream(responseBytes);
    }

    private static CloseableHttpClient buildHTTPSClient(String userName, String password) {
        SSLContext sslContext;
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
            ConnectionUtils.initSSLContext(sslContext);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new GatewayClientException("Unexpected exception building a gateway https client", e);
        }
        return HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext).build();
    }

    public static String getRestmanBundleEndpoint(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (!url.contains("restman")) {
            url = url + "restman/";
        }
        return url + "1.0/bundle";
    }
}

