/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.bundle;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyEntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadingOperation;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.EntityBundleLoader;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public class DependencyBundlesProcessor {
    private final EntityBundleLoader entityBundleLoader;
    private final DocumentTools documentTools;
    private final DocumentFileUtils documentFileUtils;

    @Inject
    public DependencyBundlesProcessor(EntityBundleLoader entityBundleLoader, DocumentTools documentTools, DocumentFileUtils documentFileUtils) {
        this.entityBundleLoader = entityBundleLoader;
        this.documentTools = documentTools;
        this.documentFileUtils = documentFileUtils;
    }

    public LinkedList<File> process(List<File> bundles, String bundleFolderPath) {
        Bundle bundleObject = this.entityBundleLoader.load(bundles, BundleLoadingOperation.VALIDATE, "ENCAPSULATED_ASSERTION", "POLICY", "FOLDER");
        LinkedList<File> processedBundles = new LinkedList<File>();
        for (File bundle : bundles) {
            Document document = this.parseBundleFile(bundle);
            Element bundleElement = document.getDocumentElement();
            NodeList items = bundleElement.getElementsByTagName("l7:Item");
            this.processEncasses(bundleObject, items);
            File processedBundle = this.writeProcessedBundle(bundle, bundleElement, bundleFolderPath);
            processedBundles.add(processedBundle);
        }
        return processedBundles;
    }

    @NotNull
    private File writeProcessedBundle(File bundle, Element document, String bundleFolderPath) {
        File processedBundle = new File(new File(bundleFolderPath), bundle.getName());
        processedBundle.deleteOnExit();
        this.documentFileUtils.createFile(document, processedBundle.toPath());
        return processedBundle;
    }

    private Document parseBundleFile(File bundle) {
        try {
            return this.documentTools.parse(bundle);
        }
        catch (DocumentParseException e) {
            throw new BundleLoadException(e.getMessage(), e);
        }
    }

    private void processEncasses(Bundle bundleObject, NodeList items) {
        StreamSupport.stream(DocumentUtils.nodeList(items).spliterator(), false).map(node -> (Element)node).filter(element -> StringUtils.equalsAny((CharSequence)DocumentUtils.getSingleChildElementTextContent(element, "l7:Type"), (CharSequence[])new CharSequence[]{"POLICY", "SERVICE"})).forEach(policyItem -> this.processPolicyItem(bundleObject, (Element)policyItem));
    }

    private void processPolicyItem(Bundle bundleObject, Element policyItem) {
        Spliterator<Node> resources = DocumentUtils.nodeList(policyItem.getElementsByTagName("l7:Resource")).spliterator();
        StreamSupport.stream(resources, false).map(node -> (Element)node).filter(element -> "policy".equals(element.getAttribute("type"))).forEach(policyResource -> this.processPolicyDocument((Element)policyResource, bundleObject));
    }

    private void processPolicyDocument(Element policyResource, Bundle bundleObject) {
        Document policyDoc;
        String policyXML = policyResource.getTextContent();
        try {
            policyDoc = DocumentUtils.stringToXMLDocument(this.documentTools, policyXML);
        }
        catch (DocumentParseException e) {
            throw new BundleLoadException(e.getMessage(), e);
        }
        DocumentUtils.nodeList(policyDoc.getDocumentElement().getElementsByTagName("L7p:Encapsulated")).forEach(node -> PolicyEntityBuilder.resolvePossibleMissingEncapsulatedAssertionDependencies(bundleObject, (Element)node));
        policyResource.setTextContent(this.documentTools.elementToString(policyDoc.getDocumentElement()));
    }
}

