/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.environment;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoaderRegistry;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleCreationMode;
import com.ca.apim.gateway.cagatewayconfig.util.environment.EnvironmentConfigurationUtils;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EnvironmentBundleBuilder {
    private static final String FILE_PREFIX = "FILE.";
    private final EntityLoaderRegistry entityLoaderRegistry;
    private final EnvironmentConfigurationUtils environmentConfigurationUtils;

    @Inject
    EnvironmentBundleBuilder(EntityLoaderRegistry entityLoaderRegistry, EnvironmentConfigurationUtils environmentConfigurationUtils) {
        this.entityLoaderRegistry = entityLoaderRegistry;
        this.environmentConfigurationUtils = environmentConfigurationUtils;
    }

    void build(Bundle bundle, Map<String, String> environmentProperties, String environmentConfigurationFolderPath, EnvironmentBundleCreationMode mode) {
        environmentProperties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("ENV.")).forEach(e -> this.addEnvToBundle(bundle, (String)e.getKey(), (String)e.getValue(), environmentConfigurationFolderPath));
        if (mode != EnvironmentBundleCreationMode.APPLICATION) {
            return;
        }
        File envDir = new File(environmentConfigurationFolderPath);
        if (envDir.exists()) {
            Collection<EntityLoader> entityLoaders = this.entityLoaderRegistry.getEntityLoaders();
            entityLoaders.parallelStream().forEach(e -> e.load(bundle, envDir));
        }
    }

    private void addEnvToBundle(Bundle bundle, String key, String value, String environmentConfigurationFolderPath) {
        int typeEndIndex;
        if (!key.startsWith("ENV.")) {
            return;
        }
        String environmentKey = key.substring(4);
        boolean isFile = environmentKey.startsWith(FILE_PREFIX);
        if (isFile) {
            environmentKey = environmentKey.substring(5);
        }
        if ((typeEndIndex = environmentKey.indexOf(46)) == -1) {
            return;
        }
        String type = environmentKey.substring(0, typeEndIndex);
        EntityLoader loader = this.entityLoaderRegistry.getLoader(type);
        if (loader == null) {
            return;
        }
        String name = environmentKey.substring(type.length() + 1);
        if (isFile) {
            value = this.environmentConfigurationUtils.loadConfigFromFile(new File(value), type, name);
        }
        loader.load(bundle, name, value, environmentConfigurationFolderPath);
    }
}

