/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.environment;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.UnsupportedGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.environment.DeploymentBundleException;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleCreationMode;
import com.ca.apim.gateway.cagatewayconfig.environment.MissingEnvironmentException;
import com.ca.apim.gateway.cagatewayconfig.util.environment.EnvironmentConfigurationUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class BundleEnvironmentValidator {
    private static final Logger LOGGER = Logger.getLogger(BundleEnvironmentValidator.class.getName());
    private final Bundle environmentBundle;
    private DocumentTools documentTools = DocumentTools.INSTANCE;

    BundleEnvironmentValidator(Bundle environmentBundle) {
        this.environmentBundle = environmentBundle;
    }

    void validateEnvironmentProvided(String bundleName, String deploymentBundle, EnvironmentBundleCreationMode mode) {
        Document deploymentBundleDocument;
        try {
            deploymentBundleDocument = this.documentTools.parse(deploymentBundle);
        }
        catch (DocumentParseException e) {
            throw new DeploymentBundleException("Unable to parse deployment bundle: " + bundleName);
        }
        Element mappingElement = DocumentUtils.getSingleChildElement(deploymentBundleDocument.getDocumentElement(), "l7:Mappings");
        List<Element> mappingElements = DocumentUtils.getChildElements(mappingElement, "l7:Mapping");
        mappingElements.forEach(mapping -> {
            Element propertiesElement = DocumentUtils.getSingleChildElement(mapping, "l7:Properties", true);
            if (propertiesElement != null) {
                this.validateElement(mode, (Element)mapping, propertiesElement);
            }
        });
    }

    private void validateElement(EnvironmentBundleCreationMode mode, Element mapping, Element propertiesElement) {
        List<Element> propertyElements = DocumentUtils.getChildElements(propertiesElement, "l7:Property");
        if (propertyElements.stream().anyMatch(p -> "FailOnNew".equals(p.getAttribute("key")) && Boolean.valueOf(DocumentUtils.getSingleChildElementTextContent(p, "l7:BooleanValue")) != false)) {
            boolean mapByName = propertyElements.stream().anyMatch(p -> "MapBy".equals(p.getAttribute("key")) && "name".equals(DocumentUtils.getSingleChildElementTextContent(p, "l7:StringValue")));
            if (!mapByName) {
                throw new DeploymentBundleException("Expected mapping to be map by name: " + this.documentTools.elementToString(mapping));
            }
            List mapToProperties = propertyElements.stream().filter(p -> "MapTo".equals(p.getAttribute("key"))).collect(Collectors.toList());
            String mapToName = DocumentUtils.getSingleChildElementTextContent((Element)mapToProperties.get(0), "l7:StringValue");
            String type = mapping.getAttribute("type");
            if (mode.isRequired(type)) {
                String entityName = EnvironmentConfigurationUtils.extractEntityName(mapToName);
                this.findInBundle(this.environmentBundle, type, entityName);
            }
        }
    }

    private void findInBundle(Bundle bundle, String type, String name) {
        GatewayEntity entity = null;
        switch (type) {
            case "CLUSTER_PROPERTY": {
                entity = bundle.getGlobalEnvironmentProperties().get("gateway." + name);
                if (entity != null) break;
                throw new MissingEnvironmentException("Missing global environment value for property: " + name);
            }
            case "ID_PROVIDER_CONFIG": {
                entity = bundle.getIdentityProviders().get(name);
                break;
            }
            case "JDBC_CONNECTION": {
                entity = bundle.getJdbcConnections().get(name);
                break;
            }
            case "SECURE_PASSWORD": {
                entity = bundle.getStoredPasswords().get(name);
                break;
            }
            case "TRUSTED_CERT": {
                entity = bundle.getTrustedCerts().get(name);
                break;
            }
            case "SSG_KEY_ENTRY": {
                entity = bundle.getPrivateKeys().get(name);
                break;
            }
            case "CASSANDRA_CONFIGURATION": {
                entity = bundle.getCassandraConnections().get(name);
                break;
            }
            case "JMS_ENDPOINT": {
                entity = bundle.getJmsDestinations().get(name);
                break;
            }
            case "SSG_ACTIVE_CONNECTOR": {
                entity = bundle.getSsgActiveConnectors().get(name);
                break;
            }
            case "GENERIC": {
                entity = bundle.getGenericEntities().get(name);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Unsupported gateway entity " + type);
                UnsupportedGatewayEntity unsupportedGatewayEntity = bundle.getUnsupportedEntities().get(UnsupportedGatewayEntity.getMappingValue(type, name));
                if (unsupportedGatewayEntity == null || !type.equals(unsupportedGatewayEntity.getType())) break;
                entity = unsupportedGatewayEntity;
            }
        }
        if (entity == null) {
            throw new MissingEnvironmentException("Missing environment value for " + type + ": " + name);
        }
    }
}

