/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.environment;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.ContextVariableEnvironmentProperty;
import com.ca.apim.gateway.cagatewayconfig.beans.ServiceEnvironmentProperty;
import com.ca.apim.gateway.cagatewayconfig.environment.BundleDetemplatizeException;
import com.ca.apim.gateway.cagatewayconfig.util.environment.EnvironmentConfigurationUtils;
import java.util.Base64;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class BundleDetemplatizer {
    private final Bundle bundle;

    BundleDetemplatizer(Bundle bundle) {
        this.bundle = bundle;
    }

    CharSequence detemplatizeBundleString(CharSequence bundleString) {
        Map<String, String> contextVariableEnvironmentVariables = this.bundle.getContextVariableEnvironmentProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ContextVariableEnvironmentProperty)e.getValue()).getValue()));
        Map<String, String> serviceEnvironmentVariables = this.bundle.getServiceEnvironmentProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ServiceEnvironmentProperty)e.getValue()).getValue()));
        bundleString = this.replaceVariableInBundle(bundleString, contextVariableEnvironmentVariables, "L7p:Base64Expression ENV_PARAM_NAME=\\\"ENV\\.(.+?)\\\"", v -> "L7p:Base64Expression stringValue=\"" + Base64.getEncoder().encodeToString(v.getBytes()) + "\"");
        bundleString = this.replaceVariableInBundle(bundleString, serviceEnvironmentVariables, "l7:StringValue>SERVICE_PROPERTY_ENV\\.(.+?)<", v -> "l7:StringValue>" + v + "<").toString();
        return bundleString;
    }

    private StringBuffer replaceVariableInBundle(CharSequence bundle, Map<String, String> mapToCheck, String variableFinderRegex, UnaryOperator<String> replacementFunction) {
        return this.replaceVariableInBundle(bundle, mapToCheck, variableFinderRegex, (varName, value) -> (String)replacementFunction.apply((String)value));
    }

    private StringBuffer replaceVariableInBundle(CharSequence bundle, Map<String, String> mapToCheck, String variableFinderRegex, BinaryOperator<String> replacementFunction) {
        Pattern setVariablePattern = Pattern.compile(variableFinderRegex);
        Matcher setVariableMatcher = setVariablePattern.matcher(bundle);
        StringBuffer replacedBundle = new StringBuffer();
        while (setVariableMatcher.find()) {
            String varName = setVariableMatcher.group(1);
            String value = mapToCheck.get(EnvironmentConfigurationUtils.extractEntityName(varName));
            if (value == null) {
                throw new BundleDetemplatizeException("Missing environment value for property: " + varName);
            }
            setVariableMatcher.appendReplacement(replacedBundle, (String)replacementFunction.apply(varName, value));
        }
        setVariableMatcher.appendTail(replacedBundle);
        return replacedBundle;
    }
}

