/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.environment;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleDefinedEntities;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadingOperation;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.EntityBundleLoader;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BundleCache {
    private final Map<String, Bundle> cache = new ConcurrentHashMap<String, Bundle>();
    private final Map<String, BundleDefinedEntities> metaDataCache = new ConcurrentHashMap<String, BundleDefinedEntities>();
    private final EntityBundleLoader entityBundleLoader;
    private final JsonFileUtils jsonFileUtils = JsonFileUtils.INSTANCE;

    @Inject
    public BundleCache(EntityBundleLoader entityBundleLoader) {
        this.entityBundleLoader = entityBundleLoader;
    }

    public Bundle getBundle(String bundlePath) {
        return this.cache.get(bundlePath);
    }

    public boolean contains(String bundlePath) {
        return this.cache.containsKey(bundlePath);
    }

    public void putBundle(String bundlePath, Bundle bundle) {
        this.cache.put(bundlePath, bundle);
    }

    public Bundle getBundleFromFile(File file) {
        if (!this.cache.containsKey(file.getPath())) {
            this.cache.put(file.getPath(), this.entityBundleLoader.load(file, BundleLoadingOperation.EXPORT, new String[0]));
        }
        return this.cache.get(file.getPath());
    }

    public Bundle getBundleFromMetadataFile(File file) {
        Bundle bundle;
        if (!this.cache.containsKey(file.getPath()) && (bundle = this.entityBundleLoader.loadMetadata(file, BundleLoadingOperation.EXPORT)) != null) {
            this.cache.put(file.getPath(), bundle);
        }
        return this.cache.get(file.getPath());
    }
}

