/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.TrustedCert;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class TrustedCertLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element trustedCertElem = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:TrustedCertificate");
        String name = DocumentUtils.getSingleChildElementTextContent(trustedCertElem, "l7:Name");
        Map<String, Object> properties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(trustedCertElem, "l7:Properties", true), "l7:Properties");
        TrustedCert cert = new TrustedCert(properties, this.getCertData(trustedCertElem));
        cert.setId(trustedCertElem.getAttribute("id"));
        cert.setName(DocumentUtils.getSingleChildElementTextContent(trustedCertElem, "l7:Name"));
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        Annotation bundleEntity = new Annotation("@bundle-hints");
        bundleEntity.setId(trustedCertElem.getAttribute("id"));
        annotations.add(bundleEntity);
        cert.setAnnotations(annotations);
        bundle.getTrustedCerts().put(name, cert);
    }

    private TrustedCert.CertificateData getCertData(Element trustedCertElem) {
        Element certDataElem = DocumentUtils.getSingleChildElement(trustedCertElem, "l7:CertificateData");
        String serialNum = DocumentUtils.getSingleChildElementTextContent(certDataElem, "l7:SerialNumber");
        if (serialNum != null) {
            return new TrustedCert.CertificateData(DocumentUtils.getSingleChildElementTextContent(certDataElem, "l7:IssuerName"), new BigInteger(serialNum), DocumentUtils.getSingleChildElementTextContent(certDataElem, "l7:SubjectName"), DocumentUtils.getSingleChildElementTextContent(certDataElem, "l7:Encoded"));
        }
        throw new BundleLoadException("Serial number of Trusted Cert must not be empty.");
    }

    @Override
    public String getEntityType() {
        return "TRUSTED_CERT";
    }
}

