/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.ListenPort;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

@Singleton
public class ListenPortLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element listenPortElement = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:ListenPort");
        String name = DocumentUtils.getSingleChildElementTextContent(listenPortElement, "l7:Name");
        String protocol = DocumentUtils.getSingleChildElementTextContent(listenPortElement, "l7:Protocol");
        Integer port = Integer.parseInt(DocumentUtils.getSingleChildElementTextContent(listenPortElement, "l7:Port"));
        Set<String> enabledFeatures = DocumentUtils.getChildElementsTextContents(DocumentUtils.getSingleChildElement(listenPortElement, "l7:EnabledFeatures"), "l7:StringValue");
        String targetServiceReference = this.getTargetServiceReferenceId(listenPortElement);
        ListenPort.ListenPortTlsSettings tlsSettings = this.getTlsSettings(listenPortElement);
        Map<String, Object> properties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(listenPortElement, "l7:Properties", true), "l7:Properties");
        if (!StringUtils.equalsAny((CharSequence)protocol, (CharSequence[])new CharSequence[]{"FTP", "FTPS"})) {
            properties.remove("useExtendedFtpCommandSet");
            if (properties.isEmpty()) {
                properties = null;
            }
        }
        ListenPort listenPort = new ListenPort();
        listenPort.setId(listenPortElement.getAttribute("id"));
        listenPort.setName(name);
        listenPort.setProtocol(protocol);
        listenPort.setPort(port);
        listenPort.setEnabledFeatures(enabledFeatures);
        listenPort.setTargetServiceReference(targetServiceReference);
        listenPort.setTlsSettings(tlsSettings);
        listenPort.setProperties(properties);
        bundle.getListenPorts().put(name, listenPort);
    }

    private String getTargetServiceReferenceId(Element listenPortElement) {
        Element targetServiceReference = DocumentUtils.getSingleChildElement(listenPortElement, "l7:TargetServiceReference", true);
        if (targetServiceReference == null) {
            return null;
        }
        return targetServiceReference.getAttribute("id");
    }

    private ListenPort.ListenPortTlsSettings getTlsSettings(Element listenPortElement) {
        Element tlsSettingsElement = DocumentUtils.getSingleChildElement(listenPortElement, "l7:TlsSettings", true);
        if (tlsSettingsElement == null) {
            return null;
        }
        ListenPort.ListenPortTlsSettings tlsSettings = new ListenPort.ListenPortTlsSettings();
        String clientAuthentication = DocumentUtils.getSingleChildElementTextContent(tlsSettingsElement, "l7:ClientAuthentication");
        tlsSettings.setClientAuthentication(ListenPort.ClientAuthentication.fromType(clientAuthentication));
        Element enabledCipherSuites = DocumentUtils.getSingleChildElement(tlsSettingsElement, "l7:EnabledCipherSuites", true);
        tlsSettings.setEnabledCipherSuites(new HashSet<String>(DocumentUtils.getChildElementsTextContents(enabledCipherSuites, "l7:StringValue")));
        Element enabledVersions = DocumentUtils.getSingleChildElement(tlsSettingsElement, "l7:EnabledVersions", true);
        tlsSettings.setEnabledVersions(new HashSet<String>(DocumentUtils.getChildElementsTextContents(enabledVersions, "l7:StringValue")));
        Element properties = DocumentUtils.getSingleChildElement(tlsSettingsElement, "l7:Properties", true);
        tlsSettings.setProperties(BuilderUtils.mapPropertiesElements(properties, "l7:Properties"));
        tlsSettings.setPrivateKey(DocumentUtils.getSingleChildElementAttribute(tlsSettingsElement, "l7:PrivateKeyReference", "id"));
        return tlsSettings;
    }

    @Override
    public String getEntityType() {
        return "SSG_CONNECTOR";
    }
}

