/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.InboundJmsDestinationDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.JmsDestination;
import com.ca.apim.gateway.cagatewayconfig.beans.JmsDestinationDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.OutboundJmsDestinationDetail;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

@Singleton
public class JmsDestinationLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element jmsDestinationEle = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:JMSDestination");
        String id = jmsDestinationEle.getAttribute("id");
        Element jmsDestinationDetailEle = DocumentUtils.getSingleChildElement(jmsDestinationEle, "l7:JMSDestinationDetail");
        String name = DocumentUtils.getSingleChildElementTextContent(jmsDestinationDetailEle, "l7:Name");
        boolean isInbound = BooleanUtils.toBoolean((String)DocumentUtils.getSingleChildElementTextContent(jmsDestinationDetailEle, "l7:Inbound"));
        boolean isTemplate = BooleanUtils.toBoolean((String)DocumentUtils.getSingleChildElementTextContent(jmsDestinationDetailEle, "l7:Template"));
        Map<String, Object> jmsDestinationDetailProps = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(jmsDestinationDetailEle, "l7:Properties", false), "l7:Properties");
        Element jmsConnectionEle = DocumentUtils.getSingleChildElement(jmsDestinationEle, "l7:JMSConnection");
        String providerType = DocumentUtils.getSingleChildElementTextContent(jmsConnectionEle, "l7:ProviderType");
        Map<String, Object> jmsConnectionProps = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(jmsConnectionEle, "l7:Properties", false), "l7:Properties");
        String initialContextFactoryClassName = (String)jmsConnectionProps.remove("jndi.initialContextFactoryClassname");
        String jndiUrl = (String)jmsConnectionProps.remove("jndi.providerUrl");
        Map<String, Object> contextPropertiesTemplateProps = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(jmsConnectionEle, "l7:ContextPropertiesTemplate", false), "l7:ContextPropertiesTemplate");
        String jndiUsername = (String)contextPropertiesTemplateProps.remove("java.naming.security.principal");
        String jndiPassword = (String)contextPropertiesTemplateProps.remove("java.naming.security.credentials");
        Map<String, Object> jndiProperties = contextPropertiesTemplateProps.entrySet().stream().filter(map -> !((String)map.getKey()).startsWith("com.l7tech.server.jms.prop.") && !((String)map.getKey()).startsWith("com.tibco.tibjms.") && !"com.l7tech.server.jms.soapAction.msgPropName".equals(map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        contextPropertiesTemplateProps.keySet().removeAll(jndiProperties.keySet());
        String destinationType = (String)jmsDestinationDetailProps.remove("type");
        String connectionFactoryName = (String)jmsConnectionProps.remove("queue.connectionFactoryName");
        String destinationName = DocumentUtils.getSingleChildElementTextContent(jmsDestinationDetailEle, "l7:DestinationName");
        String destinationUsername = (String)jmsDestinationDetailProps.remove("username");
        String destinationPassword = (String)jmsDestinationDetailProps.remove("password");
        JmsDestination.Builder builder = new JmsDestination.Builder().id(id).name(name).providerType(providerType).initialContextFactoryClassName(initialContextFactoryClassName).jndiUrl(jndiUrl).jndiUsername(jndiUsername).jndiPassword(jndiPassword).destinationType(JmsDestination.DestinationType.fromType(destinationType)).connectionFactoryName(connectionFactoryName).destinationName(destinationName).destinationUsername(destinationUsername).destinationPassword(destinationPassword);
        if (!jndiProperties.isEmpty()) {
            builder.jndiProperties(jndiProperties);
        }
        if (isInbound) {
            builder.inboundDetail(this.loadInboundDetail(jmsDestinationDetailProps, contextPropertiesTemplateProps));
        } else {
            builder.outboundDetail(this.loadOutboundDetail(isTemplate, jmsDestinationDetailProps, contextPropertiesTemplateProps));
        }
        this.removeKeystoreGoidRefs(providerType, contextPropertiesTemplateProps);
        if (!contextPropertiesTemplateProps.isEmpty()) {
            builder.additionalProperties(contextPropertiesTemplateProps);
        }
        JmsDestination jmsDestination = builder.build();
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        Annotation bundleEntity = new Annotation("@bundle-hints");
        bundleEntity.setId(jmsDestination.getId());
        annotations.add(bundleEntity);
        jmsDestination.setAnnotations(annotations);
        bundle.getJmsDestinations().put(name, jmsDestination);
    }

    private InboundJmsDestinationDetail loadInboundDetail(Map<String, Object> jmsDestinationDetailProps, Map<String, Object> contextPropertiesTemplateProps) {
        Long maxInboundMessageSize;
        int dedicatedConsumerConnectionSize;
        boolean isHardwiredService = BooleanUtils.toBoolean((String)((String)contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.hardwired.service.bool")));
        String serviceRef = null;
        if (isHardwiredService) {
            serviceRef = (String)contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.hardwired.service.id");
        }
        String soapActionMsgPropName = (String)contextPropertiesTemplateProps.remove("com.l7tech.server.jms.soapAction.msgPropName");
        InboundJmsDestinationDetail.ContentTypeSource contentTypeSource = InboundJmsDestinationDetail.ContentTypeSource.fromType((String)contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.contentType.source"));
        String contentType = (String)contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.contentType.value");
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            contentType = null;
        }
        InboundJmsDestinationDetail.ServiceResolutionSettings serviceResolutionSettings = null;
        if (ObjectUtils.anyNotNull((Object[])new Object[]{serviceRef, soapActionMsgPropName, contentTypeSource, contentType})) {
            serviceResolutionSettings = new InboundJmsDestinationDetail.ServiceResolutionSettings();
            serviceResolutionSettings.setServiceRef(serviceRef);
            serviceResolutionSettings.setSoapActionMessagePropertyName(soapActionMsgPropName);
            serviceResolutionSettings.setContentTypeSource(contentTypeSource);
            serviceResolutionSettings.setContentType(contentType);
        }
        InboundJmsDestinationDetail inboundDetail = new InboundJmsDestinationDetail();
        inboundDetail.setAcknowledgeType(InboundJmsDestinationDetail.AcknowledgeType.fromType((String)jmsDestinationDetailProps.remove("inbound.acknowledgementType")));
        inboundDetail.setReplyType(JmsDestinationDetail.ReplyType.fromType((String)jmsDestinationDetailProps.remove("replyType")));
        inboundDetail.setReplyToQueueName((String)jmsDestinationDetailProps.remove("replyToQueueName"));
        inboundDetail.setUseRequestCorrelationId((Boolean)jmsDestinationDetailProps.remove("useRequestCorrelationId"));
        inboundDetail.setServiceResolutionSettings(serviceResolutionSettings);
        inboundDetail.setFailureQueueName((String)jmsDestinationDetailProps.remove("inbound.failureQueueName"));
        if (contextPropertiesTemplateProps.containsKey("com.l7tech.server.jms.prop.dedicated.consumer.size") && 1 != (dedicatedConsumerConnectionSize = JmsDestinationLoader.convertToInteger(contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.dedicated.consumer.size")).intValue())) {
            inboundDetail.setNumOfConsumerConnections(dedicatedConsumerConnectionSize);
        }
        if (-1L != (maxInboundMessageSize = (Long)jmsDestinationDetailProps.remove("inbound.maximumSize"))) {
            inboundDetail.setMaxMessageSizeBytes(maxInboundMessageSize);
        }
        contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.dedicated.consumer.bool");
        return inboundDetail;
    }

    private OutboundJmsDestinationDetail loadOutboundDetail(boolean isTemplate, Map<String, Object> jmsDestinationDetailProps, Map<String, Object> contextPropertiesTemplateProps) {
        Integer poolSize;
        OutboundJmsDestinationDetail.PoolingType poolingType;
        OutboundJmsDestinationDetail.ConnectionPoolingSettings connectionPoolingSettings = null;
        OutboundJmsDestinationDetail.SessionPoolingSettings sessionPoolingSettings = null;
        boolean isConnectionPool = BooleanUtils.toBoolean((String)((String)contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.connection.pool.enable")));
        if (isConnectionPool) {
            poolingType = OutboundJmsDestinationDetail.PoolingType.CONNECTION;
            poolSize = JmsDestinationLoader.convertToInteger(contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.connection.pool.size"));
            Integer poolMinIdle = JmsDestinationLoader.convertToInteger(contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.connection.min.idle"));
            Integer poolMaxWait = JmsDestinationLoader.convertToInteger(contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.connection.pool.max.wait"));
            if (ObjectUtils.anyNotNull((Object[])new Object[]{poolSize, poolMinIdle, poolMaxWait})) {
                connectionPoolingSettings = new OutboundJmsDestinationDetail.ConnectionPoolingSettings(poolSize, poolMinIdle, poolMaxWait);
            }
        } else {
            poolingType = OutboundJmsDestinationDetail.PoolingType.SESSION;
            poolSize = JmsDestinationLoader.convertToInteger(contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.session.pool.size"));
            Integer poolMaxIdle = JmsDestinationLoader.convertToInteger(contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.max.session.idle"));
            Integer poolMaxWait = JmsDestinationLoader.convertToInteger(contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.session.pool.max.wait"));
            if (ObjectUtils.anyNotNull((Object[])new Object[]{poolSize, poolMaxIdle, poolMaxWait})) {
                sessionPoolingSettings = new OutboundJmsDestinationDetail.SessionPoolingSettings(poolSize, poolMaxIdle, poolMaxWait);
            }
        }
        OutboundJmsDestinationDetail outboundDetail = new OutboundJmsDestinationDetail();
        outboundDetail.setIsTemplate(isTemplate);
        outboundDetail.setReplyType(JmsDestinationDetail.ReplyType.fromType((String)jmsDestinationDetailProps.remove("replyType")));
        outboundDetail.setReplyToQueueName((String)jmsDestinationDetailProps.remove("replyToQueueName"));
        outboundDetail.setUseRequestCorrelationId((Boolean)jmsDestinationDetailProps.remove("useRequestCorrelationId"));
        outboundDetail.setMessageFormat(OutboundJmsDestinationDetail.MessageFormat.fromFormat((String)jmsDestinationDetailProps.remove("outbound.MessageType")));
        outboundDetail.setPoolingType(poolingType);
        outboundDetail.setSessionPoolingSettings(sessionPoolingSettings);
        outboundDetail.setConnectionPoolingSettings(connectionPoolingSettings);
        contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.hardwired.service.bool");
        contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.contentType.source");
        contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.contentType.value");
        return outboundDetail;
    }

    private void removeKeystoreGoidRefs(String providerType, Map<String, Object> contextPropertiesTemplateProps) {
        if ("WebSphere MQ over LDAP".equals(providerType)) {
            contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.queue.ssgKeystoreId");
        } else if ("TIBCO EMS".equals(providerType)) {
            contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.jndi.ssgKeystoreId");
            contextPropertiesTemplateProps.remove("com.tibco.tibjms.naming.ssl_identity");
            contextPropertiesTemplateProps.remove("com.tibco.tibjms.naming.ssl_password");
            contextPropertiesTemplateProps.remove("com.l7tech.server.jms.prop.queue.ssgKeystoreId");
            contextPropertiesTemplateProps.remove("com.tibco.tibjms.ssl.identity");
            contextPropertiesTemplateProps.remove("com.tibco.tibjms.ssl.password");
        }
    }

    @Override
    public String getEntityType() {
        return "JMS_ENDPOINT";
    }

    @Nullable
    private static Integer convertToInteger(Object value) {
        if (value == null) {
            return null;
        }
        return Integer.valueOf((String)value);
    }
}

