/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.BindOnlyLdapIdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.FederatedIdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProvider;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Singleton
public class IdentityProviderLoader
implements BundleEntityLoader {
    IdentityProviderLoader() {
    }

    @Override
    public void load(Bundle bundle, Element element) {
        Element identityProviderElement = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:IdentityProvider");
        String name = DocumentUtils.getSingleChildElementTextContent(identityProviderElement, "l7:Name");
        Map<String, Object> properties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(identityProviderElement, "l7:Properties", true), "l7:Properties");
        String typeString = DocumentUtils.getSingleChildElementTextContent(identityProviderElement, "l7:IdentityProviderType");
        IdentityProvider.IdentityProviderType type = Arrays.stream(IdentityProvider.IdentityProviderType.values()).filter(c -> c.getValue().equals(typeString)).findFirst().orElseThrow(() -> new BundleLoadException("Invalid Identity Provider Type: " + typeString));
        IdentityProvider identityProvider = new IdentityProvider();
        identityProvider.setId(identityProviderElement.getAttribute("id"));
        identityProvider.setName(name);
        identityProvider.setProperties(properties);
        identityProvider.setType(type);
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        Annotation bundleEntity = new Annotation("@bundle-hints");
        bundleEntity.setId(identityProviderElement.getAttribute("id"));
        annotations.add(bundleEntity);
        identityProvider.setAnnotations(annotations);
        bundle.getIdentityProviders().put(name, identityProvider);
        switch (type) {
            case BIND_ONLY_LDAP: {
                Element extensionXml = DocumentUtils.getSingleChildElement(identityProviderElement, "l7:Extension");
                identityProvider.setIdentityProviderDetail(this.buildBindOnlyLdapIdentityProviderDetail(DocumentUtils.getSingleChildElement(extensionXml, "l7:BindOnlyLdapIdentityProviderDetail")));
                break;
            }
            case FEDERATED: {
                Element extensionXml = DocumentUtils.getSingleChildElement(identityProviderElement, "l7:Extension", true);
                if (extensionXml == null) break;
                identityProvider.setIdentityProviderDetail(this.buildFederatedIdentityProviderDetail(DocumentUtils.getSingleChildElement(extensionXml, "l7:FederatedIdentityProviderDetail")));
                break;
            }
        }
    }

    @NotNull
    private BindOnlyLdapIdentityProviderDetail buildBindOnlyLdapIdentityProviderDetail(Element bindOnlyLdapIdentityProviderDetailXml) {
        BindOnlyLdapIdentityProviderDetail identityProviderDetail = new BindOnlyLdapIdentityProviderDetail();
        identityProviderDetail.setServerUrls(DocumentUtils.getChildElementsTextContents(DocumentUtils.getSingleChildElement(bindOnlyLdapIdentityProviderDetailXml, "l7:ServerUrls"), "l7:StringValue"));
        identityProviderDetail.setUseSslClientAuthentication(Boolean.parseBoolean(DocumentUtils.getSingleChildElementTextContent(bindOnlyLdapIdentityProviderDetailXml, "l7:UseSslClientAuthentication")));
        identityProviderDetail.setBindPatternPrefix(DocumentUtils.getSingleChildElementTextContent(bindOnlyLdapIdentityProviderDetailXml, "l7:BindPatternPrefix"));
        identityProviderDetail.setBindPatternSuffix(DocumentUtils.getSingleChildElementTextContent(bindOnlyLdapIdentityProviderDetailXml, "l7:BindPatternSuffix"));
        return identityProviderDetail;
    }

    private FederatedIdentityProviderDetail buildFederatedIdentityProviderDetail(Element federatedIdentityProviderDetailXml) {
        if (federatedIdentityProviderDetailXml == null) {
            return null;
        }
        List<String> certReferences = DocumentUtils.getChildElementAttributeValues(DocumentUtils.getSingleChildElement(federatedIdentityProviderDetailXml, "l7:CertificateReferences"), "l7:Reference", "id");
        return new FederatedIdentityProviderDetail(new HashSet<String>(certReferences));
    }

    @Override
    public String getEntityType() {
        return "ID_PROVIDER_CONFIG";
    }
}

