/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BundleEntityLoaderRegistry {
    private final Map<String, BundleEntityLoader> entityLoaders;

    @Inject
    @VisibleForTesting
    public BundleEntityLoaderRegistry(Set<BundleEntityLoader> loaders) {
        this.entityLoaders = Collections.unmodifiableMap(loaders.stream().collect(Collectors.toMap(BundleEntityLoader::getEntityType, Function.identity())));
    }

    public BundleEntityLoader getLoader(String type) {
        return this.entityLoaders.get(type);
    }

    @VisibleForTesting
    public Map<String, BundleEntityLoader> getEntityLoaders() {
        return this.entityLoaders;
    }
}

