/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.TrustedCert;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.SupplierWithIO;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.CertificateUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class TrustedCertEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 700;
    private final IdGenerator idGenerator;
    private final SSLSocketFactory acceptAllSocketFactory;
    private final CertificateFactory certFactory;

    @Inject
    TrustedCertEntityBuilder(IdGenerator idGenerator, SSLSocketFactory acceptAllSocketFactory, CertificateFactory certFactory) {
        this.idGenerator = idGenerator;
        this.acceptAllSocketFactory = acceptAllSocketFactory;
        this.certFactory = certFactory;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map trustedCertMap = Optional.ofNullable(bundle.getTrustedCerts()).orElse(Collections.emptyMap());
            return this.buildEntities(trustedCertMap, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getTrustedCerts(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                return entities.entrySet().stream().map(trustedCertEntry -> EntityBuilderHelper.getEntityWithOnlyMapping("TRUSTED_CERT", (String)trustedCertEntry.getKey(), this.generateCertificateId((TrustedCert)trustedCertEntry.getValue()))).collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                return entities.entrySet().stream().map(trustedCertEntry -> this.buildTrustedCertEntity((String)trustedCertEntry.getKey(), (TrustedCert)trustedCertEntry.getValue(), bundle.getCertificateFiles(), document)).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    private Entity buildTrustedCertEntity(String name, TrustedCert trustedCert, Map<String, SupplierWithIO<InputStream>> certificateFiles, Document document) {
        String id = this.generateCertificateId(trustedCert);
        trustedCert.setId(id);
        Element trustedCertElem = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:TrustedCertificate", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), DocumentUtils.createElementWithTextContent(document, "l7:Name", name), this.buildCertData(name, trustedCert, certificateFiles, document));
        BuilderUtils.buildAndAppendPropertiesElement(trustedCert.createProperties(), document, trustedCertElem);
        return EntityBuilderHelper.getEntityWithNameMapping("TRUSTED_CERT", name, id, trustedCertElem);
    }

    private String generateCertificateId(TrustedCert trustedCert) {
        if (trustedCert != null && trustedCert.getAnnotatedEntity() != null && trustedCert.getAnnotatedEntity().getId() != null) {
            return trustedCert.getAnnotatedEntity().getId();
        }
        return this.idGenerator.generate();
    }

    private Element buildCertData(String name, TrustedCert trustedCert, Map<String, SupplierWithIO<InputStream>> certificateFiles, Document document) {
        if (name.startsWith("https://")) {
            return this.buildCertDataFromUrl(name, document);
        }
        if (certificateFiles.get(name) != null) {
            return CertificateUtils.buildCertDataFromFile(certificateFiles.get(name), document, this.certFactory);
        }
        if (trustedCert.getCertificateData() != null) {
            TrustedCert.CertificateData certData = trustedCert.getCertificateData();
            return CertificateUtils.createCertDataElementFromCert(certData.getIssuerName(), certData.getSerialNumber(), certData.getSubjectName(), certData.getEncodedData(), document);
        }
        throw new EntityBuilderException("Trusted Cert must be loaded from a specified url, or from a certificate file that has the same name as the Trusted Cert.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element buildCertDataFromUrl(String name, Document document) {
        URL url = this.getUrl(name);
        int port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        try (SSLSocket socket = (SSLSocket)this.acceptAllSocketFactory.createSocket(url.getHost(), port);){
            socket.startHandshake();
            Certificate[] certs = socket.getSession().getPeerCertificates();
            if (certs.length <= 0) throw new EntityBuilderException("No certificates were found in the given url.");
            if (certs[0] instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)certs[0];
                Element element = CertificateUtils.createCertDataElementFromCert(cert.getIssuerDN().getName(), cert.getSerialNumber(), cert.getSubjectDN().getName(), Base64.getEncoder().encodeToString(cert.getEncoded()), document);
                return element;
            }
            throw new EntityBuilderException("Certificate from url is not in X.509 format.");
        }
        catch (IOException | CertificateEncodingException e) {
            throw new EntityBuilderException(e.getMessage());
        }
    }

    @NotNull
    @VisibleForTesting
    URL getUrl(String name) {
        URL url;
        try {
            url = new URL(name);
        }
        catch (MalformedURLException e) {
            throw new EntityBuilderException("The url specified is malformed: " + e.getMessage(), e);
        }
        return url;
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

