/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.StoredPassword;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class StoredPasswordEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 900;
    private final IdGenerator idGenerator;

    @Inject
    StoredPasswordEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map storedPasswordMap = Optional.ofNullable(bundle.getStoredPasswords()).orElse(Collections.emptyMap());
            return this.buildEntities(storedPasswordMap, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getStoredPasswords(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                return entities.keySet().stream().map(o -> EntityBuilderHelper.getEntityWithOnlyMapping("SECURE_PASSWORD", o, this.idGenerator.generate())).collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                return entities.entrySet().stream().map(e -> this.buildStoredPasswordEntity((String)e.getKey(), (StoredPassword)e.getValue(), document)).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    private Entity buildStoredPasswordEntity(String name, StoredPassword storedPassword, Document document) {
        String id = this.idGenerator.generate();
        storedPassword.setId(id);
        Element storedPasswordElement = DocumentUtils.createElementWithAttribute(document, "l7:StoredPassword", "id", id);
        storedPasswordElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Name", name));
        storedPasswordElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Password", storedPassword.getPassword()));
        BuilderUtils.buildAndAppendPropertiesElement(storedPassword.getProperties(), document, storedPasswordElement);
        return EntityBuilderHelper.getEntityWithNameMapping("SECURE_PASSWORD", name, id, storedPasswordElement);
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

