/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Base64;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public interface PolicyAssertionBuilder {
    public void buildAssertionElement(Element var1, PolicyBuilderContext var2) throws DocumentParseException;

    public String getAssertionTagName();

    default public String getIdFromAnnotableEntity(GatewayEntity gatewayEntity, IdGenerator idGenerator) {
        AnnotatedEntity<GatewayEntity> annotatedEntity;
        if (gatewayEntity instanceof AnnotableEntity && (annotatedEntity = ((AnnotableEntity)((Object)gatewayEntity)).getAnnotatedEntity()) != null && annotatedEntity.getId() != null) {
            return annotatedEntity.getId();
        }
        return idGenerator.generate();
    }

    public static void prepareBase64Element(Document policyDocument, Element assertionElement, String elementName, String base64ElementName) {
        Element element;
        try {
            element = DocumentUtils.getSingleElement(assertionElement, elementName);
        }
        catch (DocumentParseException e) {
            throw new EntityBuilderException("Did not find '" + elementName + "' tag for SetVariableAssertion. Not generating Base64ed version");
        }
        String expression = PolicyAssertionBuilder.getCDataOrText(element);
        String encoded = Base64.getEncoder().encodeToString(expression.getBytes());
        assertionElement.insertBefore(DocumentUtils.createElementWithAttribute(policyDocument, base64ElementName, "stringValue", encoded), element);
        assertionElement.removeChild(element);
    }

    public static String getCDataOrText(Element element) {
        StringBuilder content = new StringBuilder();
        NodeList children = element.getChildNodes();
        for (Node child : DocumentUtils.nodeList(children)) {
            short nodeType = child.getNodeType();
            if (nodeType == 3) {
                content.append(child.getTextContent());
                continue;
            }
            if (nodeType == 4) {
                content.append(((CDATASection)child).getData());
                break;
            }
            throw new EntityBuilderException("Unexpected set variable assertion expression node type: " + child.getNodeName());
        }
        return StringEscapeUtils.unescapeXml((String)content.toString());
    }
}

