/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.ListenPort;
import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleUtils;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class ListenPortEntityBuilder
implements EntityBuilder {
    private static final Map<String, ListenPort> DEFAULT_PORTS = MapUtils.unmodifiableMap(ListenPortEntityBuilder.createDefaultListenPorts());
    private static final String USES_TLS = "usesTLS";
    private static final Integer ORDER = 1200;
    private final IdGenerator idGenerator;

    @Inject
    ListenPortEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map listenPortMap = Optional.ofNullable(bundle.getListenPorts()).orElse(Collections.emptyMap());
            return this.buildEntities(listenPortMap, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getListenPorts(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        Stream<Entity> userPorts = entities.entrySet().stream().map(listenPortEntry -> this.buildListenPortEntity(bundle, (String)listenPortEntry.getKey(), (ListenPort)listenPortEntry.getValue(), document));
        switch (bundleType) {
            case DEPLOYMENT: {
                return userPorts.collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                Stream<Entity> defaultPorts = DEFAULT_PORTS.entrySet().stream().filter(p -> entities.values().stream().noneMatch(up -> ((ListenPort)up).getPort() == ((ListenPort)p.getValue()).getPort())).map(listenPortEntry -> {
                    Entity entity = this.buildListenPortEntity(bundle, (String)listenPortEntry.getKey(), (ListenPort)listenPortEntry.getValue(), document);
                    entity.setMappingAction("NewOrExisting");
                    return entity;
                });
                return Stream.concat(userPorts, defaultPorts).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    Entity buildListenPortEntity(Bundle bundle, String name, ListenPort listenPort, Document document) {
        Element listenPortElement = document.createElement("l7:ListenPort");
        String id = this.idGenerator.generate();
        listenPortElement.setAttribute("id", id);
        listenPortElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Name", name));
        listenPortElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Enabled", Boolean.TRUE.toString()));
        listenPortElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Protocol", listenPort.getProtocol()));
        listenPortElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Port", Integer.toString(listenPort.getPort())));
        Element enabledFeatures = document.createElement("l7:EnabledFeatures");
        listenPort.getEnabledFeatures().forEach(s -> enabledFeatures.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:StringValue", s)));
        listenPortElement.appendChild(enabledFeatures);
        if (listenPort.getTargetServiceReference() != null) {
            listenPortElement.appendChild(this.createServiceElement(bundle, name, listenPort, document));
        }
        if (listenPort.getTlsSettings() != null) {
            listenPortElement.appendChild(this.createTlsSettings(bundle, name, listenPort, document));
        }
        BuilderUtils.buildAndAppendPropertiesElement(listenPort.getProperties(), document, listenPortElement);
        return EntityBuilderHelper.getEntityWithNameMapping("SSG_CONNECTOR", name, id, listenPortElement);
    }

    private Element createServiceElement(Bundle bundle, String name, ListenPort listenPort, Document document) {
        String targetServiceReference = listenPort.getTargetServiceReference();
        Service service = bundle.getServices().get(targetServiceReference);
        if (service == null || service.getId() == null) {
            service = EnvironmentBundleUtils.getDeploymentBundle().getServices().get(targetServiceReference);
        }
        if (service == null) {
            throw new EntityBuilderException("Could not find service binded to listen port " + name + ". Service Path: " + targetServiceReference);
        }
        return DocumentUtils.createElementWithAttribute(document, "l7:TargetServiceReference", "id", service.getId());
    }

    private Element createTlsSettings(Bundle bundle, String name, ListenPort listenPort, Document document) {
        ListenPort.ListenPortTlsSettings tlsSettings = listenPort.getTlsSettings();
        Element tlsSettingsElement = document.createElement("l7:TlsSettings");
        tlsSettingsElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:ClientAuthentication", tlsSettings.getClientAuthentication().getType()));
        if (StringUtils.isNotEmpty((CharSequence)tlsSettings.getPrivateKey())) {
            PrivateKey privateKey = bundle.getPrivateKeys().get(tlsSettings.getPrivateKey());
            if (privateKey == null) {
                throw new EntityBuilderException("Could not find Private Key " + tlsSettings.getPrivateKey() + " associated to Listen Port " + name);
            }
            tlsSettingsElement.appendChild(DocumentUtils.createElementWithAttribute(document, "l7:PrivateKeyReference", "id", privateKey.getId()));
        }
        if (CollectionUtils.isNotEmpty(tlsSettings.getEnabledVersions())) {
            Element enabledVersions = document.createElement("l7:EnabledVersions");
            tlsSettings.getEnabledVersions().forEach(s -> enabledVersions.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:StringValue", s)));
            tlsSettingsElement.appendChild(enabledVersions);
        }
        if (CollectionUtils.isNotEmpty(tlsSettings.getEnabledCipherSuites())) {
            Element enabledCipherSuites = document.createElement("l7:EnabledCipherSuites");
            tlsSettings.getEnabledCipherSuites().forEach(s -> enabledCipherSuites.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:StringValue", s)));
            tlsSettingsElement.appendChild(enabledCipherSuites);
        }
        BuilderUtils.buildAndAppendPropertiesElement(tlsSettings.getProperties(), document, tlsSettingsElement);
        return tlsSettingsElement;
    }

    static Map<String, ListenPort> createDefaultListenPorts() {
        HashMap<String, ListenPort> defaultPorts = new HashMap<String, ListenPort>();
        defaultPorts.put("Default HTTP (8080)", ListenPortEntityBuilder.createDefaultHttp());
        defaultPorts.put("Default HTTPS (8443)", ListenPortEntityBuilder.createDefaultHttps());
        return defaultPorts;
    }

    @NotNull
    static ListenPort createDefaultHttps() {
        ListenPort defaultHttps = new ListenPort();
        defaultHttps.setPort(ListenPort.HTTPS_DEFAULT_PORT);
        defaultHttps.setProtocol("HTTPS");
        defaultHttps.setEnabledFeatures(new HashSet<String>(Arrays.asList(ListenPort.Feature.MESSAGE_INPUT.getDescription(), ListenPort.Feature.ADMIN_REMOTE.getDescription(), ListenPort.Feature.ADMIN_APPLET.getDescription(), ListenPort.Feature.OTHER_SERVLETS.getDescription())));
        defaultHttps.setTlsSettings(new ListenPort.ListenPortTlsSettings());
        defaultHttps.getTlsSettings().setClientAuthentication(ListenPort.ClientAuthentication.OPTIONAL);
        defaultHttps.getTlsSettings().setEnabledVersions(new HashSet<String>(ListenPort.TLS_VERSIONS));
        defaultHttps.getTlsSettings().setEnabledCipherSuites(new HashSet<String>(ListenPort.DEFAULT_RECOMMENDED_CIPHERS));
        defaultHttps.getTlsSettings().setProperties(new HashMap<String, Object>());
        defaultHttps.getTlsSettings().getProperties().put(USES_TLS, Boolean.TRUE);
        return defaultHttps;
    }

    @NotNull
    static ListenPort createDefaultHttp() {
        ListenPort defaultHttp = new ListenPort();
        defaultHttp.setPort(ListenPort.HTTP_DEFAULT_PORT);
        defaultHttp.setProtocol("HTTP");
        defaultHttp.setEnabledFeatures(new HashSet<String>(Arrays.asList(ListenPort.Feature.MESSAGE_INPUT.getDescription(), ListenPort.Feature.POLICYDISCO.getDescription(), ListenPort.Feature.PING.getDescription(), ListenPort.Feature.STS.getDescription(), ListenPort.Feature.WSDLPROXY.getDescription(), ListenPort.Feature.SNMPQUERY.getDescription())));
        return defaultHttp;
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

