/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.InboundJmsDestinationDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.JmsDestination;
import com.ca.apim.gateway.cagatewayconfig.beans.JmsDestinationDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.KeyStoreType;
import com.ca.apim.gateway.cagatewayconfig.beans.OutboundJmsDestinationDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleUtils;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class JmsDestinationEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 1500;
    private static final String INBOUND_CONTENT_TYPE_SOURCE_NONE = "";
    private static final String INBOUND_CONTENT_TYPE_SOURCE_FREE_FORM = "com.l7tech.server.jms.prop.contentType.freeform";
    private static final String INBOUND_CONTENT_TYPE_SOURCE_JMS_PROPERTY = "com.l7tech.server.jms.prop.contentType.header";
    private final IdGenerator idGenerator;

    @Inject
    JmsDestinationEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map jmsDestinationMap = Optional.ofNullable(bundle.getJmsDestinations()).orElse(Collections.emptyMap());
            return this.buildEntities(jmsDestinationMap, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getJmsDestinations(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                return entities.entrySet().stream().map(e -> EntityBuilderHelper.getEntityWithOnlyMapping("JMS_ENDPOINT", bundle.applyUniqueName((String)e.getKey(), EntityBuilder.BundleType.ENVIRONMENT), this.generateId((JmsDestination)e.getValue()))).collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                return entities.entrySet().stream().map(e -> this.buildEntity(bundle, bundle.applyUniqueName((String)e.getKey(), bundleType), (JmsDestination)e.getValue(), document)).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }

    private Entity buildEntity(Bundle bundle, String name, JmsDestination jmsDestination, Document document) {
        String id = this.generateId(jmsDestination);
        boolean isInbound = jmsDestination.getInboundDetail() != null;
        Element jmsDestinationDetailEle = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:JMSDestinationDetail", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), DocumentUtils.createElementWithTextContent(document, "l7:Name", name), DocumentUtils.createElementWithTextContent(document, "l7:DestinationName", jmsDestination.getDestinationName()), DocumentUtils.createElementWithTextContent(document, "l7:Inbound", isInbound));
        HashMap<String, Object> jmsDestinationDetailProps = new HashMap<String, Object>();
        jmsDestinationDetailProps.put("type", jmsDestination.getDestinationType().getType());
        jmsDestinationDetailProps.put("username", jmsDestination.getDestinationUsername());
        jmsDestinationDetailProps.put("password", this.getPassword(bundle, jmsDestination.getDestinationPasswordRef(), jmsDestination.getDestinationPassword()));
        Map contextPropertiesTemplateProps = Optional.ofNullable(jmsDestination.getJndiProperties()).orElseGet(HashMap::new);
        contextPropertiesTemplateProps.put("java.naming.security.principal", jmsDestination.getJndiUsername());
        contextPropertiesTemplateProps.put("java.naming.security.credentials", this.getPassword(bundle, jmsDestination.getJndiPasswordRef(), jmsDestination.getJndiPassword()));
        boolean isTemplate = false;
        if (isInbound) {
            this.buildInboundDestination(bundle, name, jmsDestination, jmsDestinationDetailProps, contextPropertiesTemplateProps);
        } else {
            isTemplate = jmsDestination.getOutboundDetail().isTemplate();
            this.buildOutboundDestination(jmsDestination, jmsDestinationDetailProps, contextPropertiesTemplateProps);
        }
        String providerType = jmsDestination.getProviderType();
        if (jmsDestination.getAdditionalProperties() != null && !jmsDestination.getAdditionalProperties().isEmpty()) {
            contextPropertiesTemplateProps.putAll(jmsDestination.getAdditionalProperties());
            this.buildPrivateKeyReferences(bundle, providerType, contextPropertiesTemplateProps);
        }
        jmsDestinationDetailEle.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Enabled", true));
        jmsDestinationDetailEle.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Template", isTemplate));
        BuilderUtils.buildAndAppendPropertiesElement(jmsDestinationDetailProps, document, jmsDestinationDetailEle);
        String jmsConnectionEleId = this.idGenerator.generate();
        Element jmsConnectionEle = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:JMSConnection", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)jmsConnectionEleId), new Element[0]);
        if (StringUtils.isNotEmpty((CharSequence)providerType)) {
            jmsConnectionEle.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:ProviderType", providerType));
        }
        DocumentUtils.createElementWithTextContent(document, "l7:Template", isTemplate);
        HashMap<String, Object> jmsConnectionProps = new HashMap<String, Object>();
        jmsConnectionProps.put("jndi.initialContextFactoryClassname", jmsDestination.getInitialContextFactoryClassName());
        jmsConnectionProps.put("jndi.providerUrl", jmsDestination.getJndiUrl());
        jmsConnectionProps.put("queue.connectionFactoryName", jmsDestination.getConnectionFactoryName());
        jmsConnectionProps.put("username", jmsDestination.getDestinationUsername());
        jmsConnectionProps.put("password", this.getPassword(bundle, jmsDestination.getDestinationPasswordRef(), jmsDestination.getDestinationPassword()));
        BuilderUtils.buildAndAppendPropertiesElement(jmsConnectionProps, document, jmsConnectionEle);
        jmsConnectionEle.appendChild(BuilderUtils.buildPropertiesElement(contextPropertiesTemplateProps, document, "l7:ContextPropertiesTemplate"));
        Element jmsDestinationEle = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:JMSDestination", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), new Element[0]);
        jmsDestinationEle.appendChild(jmsDestinationDetailEle);
        jmsDestinationEle.appendChild(jmsConnectionEle);
        return EntityBuilderHelper.getEntityWithNameMapping("JMS_ENDPOINT", name, id, jmsDestinationEle);
    }

    private String getPassword(Bundle bundle, String passwordRef, String plaintext) {
        if (passwordRef != null) {
            if (bundle.getStoredPasswords().get(passwordRef) == null) {
                throw new EntityBuilderException("JMS destination is referencing missing stored password '" + passwordRef + "'");
            }
            return String.format("${secpass.%s.plaintext}", passwordRef);
        }
        return plaintext;
    }

    private void buildPrivateKeyReferences(Bundle bundle, String providerType, Map<String, Object> contextPropertiesTemplateProps) {
        String alias = (String)contextPropertiesTemplateProps.get("com.l7tech.server.jms.prop.queue.ssgKeyAlias");
        if (StringUtils.isNotEmpty((CharSequence)alias)) {
            if (null == bundle.getPrivateKeys().get(alias)) {
                throw new EntityBuilderException("Jms destination is referencing missing private key '" + alias + "'");
            }
            contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.queue.ssgKeystoreId", KeyStoreType.GENERIC.getId());
            if ("TIBCO EMS".equals(providerType)) {
                contextPropertiesTemplateProps.put("com.tibco.tibjms.ssl.identity", "com.l7tech.server.jms.prop.keystore.bytes\t" + KeyStoreType.GENERIC.getId() + "\t" + alias);
                contextPropertiesTemplateProps.put("com.tibco.tibjms.ssl.password", "com.l7tech.server.jms.prop.keystore.password\t" + KeyStoreType.GENERIC.getId() + "\t" + alias);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(alias = (String)contextPropertiesTemplateProps.get("com.l7tech.server.jms.prop.jndi.ssgKeyAlias")))) {
            if (null == bundle.getPrivateKeys().get(alias)) {
                throw new EntityBuilderException("Jms destination is referencing missing private key '" + alias + "'");
            }
            if ("TIBCO EMS".equals(providerType)) {
                contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.jndi.ssgKeystoreId", KeyStoreType.GENERIC.getId());
                contextPropertiesTemplateProps.put("com.tibco.tibjms.naming.ssl_identity", "com.l7tech.server.jms.prop.keystore\t" + KeyStoreType.GENERIC.getId() + "\t" + alias);
                contextPropertiesTemplateProps.put("com.tibco.tibjms.naming.ssl_password", "com.l7tech.server.jms.prop.keystore.password\t" + KeyStoreType.GENERIC.getId() + "\t" + alias);
            }
        }
    }

    private void buildInboundDestination(Bundle bundle, String name, JmsDestination jmsDestination, Map<String, Object> jmsDestinationDetailProps, Map<String, Object> contextPropertiesTemplateProps) {
        InboundJmsDestinationDetail inboundDetail = jmsDestination.getInboundDetail();
        jmsDestinationDetailProps.put("inbound.acknowledgementType", inboundDetail.getAcknowledgeType().getType());
        JmsDestinationDetail.ReplyType replyType = inboundDetail.getReplyType();
        jmsDestinationDetailProps.put("replyType", replyType.getType());
        if (JmsDestinationDetail.ReplyType.SPECIFIED_QUEUE.equals((Object)replyType)) {
            jmsDestinationDetailProps.put("replyToQueueName", inboundDetail.getReplyToQueueName());
        }
        jmsDestinationDetailProps.put("useRequestCorrelationId", inboundDetail.isUseRequestCorrelationId());
        InboundJmsDestinationDetail.ServiceResolutionSettings serviceResolutionSettings = inboundDetail.getServiceResolutionSettings();
        if (serviceResolutionSettings != null) {
            String serviceRef = serviceResolutionSettings.getServiceRef();
            if (serviceRef != null) {
                Service service = bundle.getServices().get(serviceRef);
                if (service == null) {
                    service = EnvironmentBundleUtils.getDeploymentBundle().getServices().get(serviceRef);
                }
                if (service == null) {
                    throw new EntityBuilderException("Could not find associated Service for inbound JMS Destination: " + name + ". Service Path: " + serviceRef);
                }
                contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.hardwired.service.bool", Boolean.TRUE.toString());
                contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.hardwired.service.id", service.getId());
            } else {
                contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.hardwired.service.bool", Boolean.FALSE.toString());
            }
            JmsDestinationEntityBuilder.putToMapIfValueIsNotNull(contextPropertiesTemplateProps, "com.l7tech.server.jms.soapAction.msgPropName", serviceResolutionSettings.getSoapActionMessagePropertyName());
            contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.contentType.source", this.getContentTypeSource(serviceResolutionSettings));
            String contentType = serviceResolutionSettings.getContentType();
            contentType = Strings.nullToEmpty((String)contentType);
            contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.contentType.value", contentType);
        }
        if (InboundJmsDestinationDetail.AcknowledgeType.ON_COMPLETION.equals((Object)inboundDetail.getAcknowledgeType())) {
            JmsDestinationEntityBuilder.putToMapIfValueIsNotNull(jmsDestinationDetailProps, "inbound.failureQueueName", inboundDetail.getFailureQueueName());
        }
        contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.dedicated.consumer.bool", Boolean.TRUE.toString());
        Integer numOfConsumerConnections = inboundDetail.getNumOfConsumerConnections();
        if (numOfConsumerConnections == null) {
            numOfConsumerConnections = 1;
        }
        contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.dedicated.consumer.size", Integer.toString(numOfConsumerConnections));
        Long maxInboundMessageSize = inboundDetail.getMaxMessageSizeBytes();
        if (maxInboundMessageSize == null) {
            maxInboundMessageSize = -1L;
        }
        jmsDestinationDetailProps.put("inbound.maximumSize", maxInboundMessageSize);
    }

    private String getContentTypeSource(InboundJmsDestinationDetail.ServiceResolutionSettings serviceResolutionSettings) {
        String contentTypeSource;
        if (serviceResolutionSettings.getContentTypeSource() == null) {
            return INBOUND_CONTENT_TYPE_SOURCE_NONE;
        }
        switch (serviceResolutionSettings.getContentTypeSource()) {
            case NONE: {
                contentTypeSource = INBOUND_CONTENT_TYPE_SOURCE_NONE;
                break;
            }
            case FREE_FORM: {
                contentTypeSource = INBOUND_CONTENT_TYPE_SOURCE_FREE_FORM;
                break;
            }
            case JMS_PROPERTY: {
                contentTypeSource = INBOUND_CONTENT_TYPE_SOURCE_JMS_PROPERTY;
                break;
            }
            default: {
                contentTypeSource = INBOUND_CONTENT_TYPE_SOURCE_NONE;
            }
        }
        return contentTypeSource;
    }

    private void buildOutboundDestination(JmsDestination jmsDestination, Map<String, Object> jmsDestinationDetailProps, Map<String, Object> contextPropertiesTemplateProps) {
        OutboundJmsDestinationDetail outboundDetail = jmsDestination.getOutboundDetail();
        JmsDestinationDetail.ReplyType replyType = outboundDetail.getReplyType();
        jmsDestinationDetailProps.put("replyType", replyType.getType());
        if (JmsDestinationDetail.ReplyType.SPECIFIED_QUEUE.equals((Object)replyType)) {
            jmsDestinationDetailProps.put("replyToQueueName", outboundDetail.getReplyToQueueName());
        }
        jmsDestinationDetailProps.put("useRequestCorrelationId", outboundDetail.isUseRequestCorrelationId());
        jmsDestinationDetailProps.put("outbound.MessageType", outboundDetail.getMessageFormat().getType());
        OutboundJmsDestinationDetail.PoolingType poolingType = outboundDetail.getPoolingType();
        if (OutboundJmsDestinationDetail.PoolingType.CONNECTION.equals((Object)poolingType)) {
            contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.connection.pool.enable", Boolean.TRUE.toString());
            OutboundJmsDestinationDetail.ConnectionPoolingSettings connectionPoolingSettings = outboundDetail.getConnectionPoolingSettings();
            if (connectionPoolingSettings != null) {
                JmsDestinationEntityBuilder.putToMapIfValueIsNotNull(contextPropertiesTemplateProps, "com.l7tech.server.jms.prop.connection.pool.size", connectionPoolingSettings.getSize());
                JmsDestinationEntityBuilder.putToMapIfValueIsNotNull(contextPropertiesTemplateProps, "com.l7tech.server.jms.prop.connection.min.idle", connectionPoolingSettings.getMinIdle());
                JmsDestinationEntityBuilder.putToMapIfValueIsNotNull(contextPropertiesTemplateProps, "com.l7tech.server.jms.prop.connection.pool.max.wait", connectionPoolingSettings.getMaxWaitMs());
            }
        } else {
            contextPropertiesTemplateProps.put("com.l7tech.server.jms.prop.connection.pool.enable", Boolean.FALSE.toString());
            OutboundJmsDestinationDetail.SessionPoolingSettings sessionPoolingSettings = outboundDetail.getSessionPoolingSettings();
            if (sessionPoolingSettings != null) {
                JmsDestinationEntityBuilder.putToMapIfValueIsNotNull(contextPropertiesTemplateProps, "com.l7tech.server.jms.prop.session.pool.size", sessionPoolingSettings.getSize());
                JmsDestinationEntityBuilder.putToMapIfValueIsNotNull(contextPropertiesTemplateProps, "com.l7tech.server.jms.prop.max.session.idle", sessionPoolingSettings.getMaxIdle());
                JmsDestinationEntityBuilder.putToMapIfValueIsNotNull(contextPropertiesTemplateProps, "com.l7tech.server.jms.prop.session.pool.max.wait", sessionPoolingSettings.getMaxWaitMs());
            }
        }
    }

    private String generateId(JmsDestination jmsDestination) {
        if (jmsDestination != null && jmsDestination.getAnnotatedEntity() != null && StringUtils.isNotBlank((CharSequence)jmsDestination.getAnnotatedEntity().getId())) {
            return jmsDestination.getAnnotatedEntity().getId();
        }
        return this.idGenerator.generate();
    }

    private static void putToMapIfValueIsNotNull(@NotNull Map<String, Object> map, @NotNull String key, @Nullable Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

