/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.TrustedCert;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HttpRoutingAssertionBuilder
implements PolicyAssertionBuilder {
    @Override
    public void buildAssertionElement(Element assertionElement, PolicyBuilderContext policyBuilderContext) {
        Bundle bundle = policyBuilderContext.getBundle();
        Element trustedCertNameElement = DocumentUtils.getSingleChildElement(assertionElement, "L7p:TlsTrustedCertNames", true);
        if (trustedCertNameElement != null && trustedCertNameElement.getChildNodes().getLength() > 0) {
            Element trustedCertGoidElement = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:TlsTrustedCertGoids", "goidArrayValue", "included");
            assertionElement.insertBefore(trustedCertGoidElement, trustedCertNameElement);
            NodeList trustedCertNamesList = trustedCertNameElement.getChildNodes();
            for (int i = 0; i < trustedCertNamesList.getLength(); ++i) {
                String trustedCertName = trustedCertNamesList.item(i).getAttributes().getNamedItem("stringValue").getTextContent();
                TrustedCert trustedCert = bundle.getTrustedCerts().get(trustedCertName);
                String trustedCertId = this.getIdFromAnnotableEntity(trustedCert, policyBuilderContext.getIdGenerator());
                Element trustedCertGoidItem = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:item", "goidValue", trustedCertId);
                trustedCertGoidElement.appendChild(trustedCertGoidItem);
            }
        }
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:HttpRoutingAssertion";
    }
}

