/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GenericEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import org.w3c.dom.Element;

public class Http2AssertionBuilder
implements PolicyAssertionBuilder {
    @Override
    public void buildAssertionElement(Element assertionElement, PolicyBuilderContext policyBuilderContext) {
        Bundle bundle = policyBuilderContext.getBundle();
        Element http2ClientNameEle = DocumentUtils.getSingleChildElement(assertionElement, "L7p:Http2ClientConfigName", true);
        if (http2ClientNameEle != null) {
            String http2ClientName = http2ClientNameEle.getAttributes().getNamedItem("stringValue").getTextContent();
            http2ClientNameEle.setAttribute("stringValue", bundle.applyUniqueName(http2ClientName, EntityBuilder.BundleType.ENVIRONMENT));
            GenericEntity http2Client = bundle.getGenericEntities().get(http2ClientName);
            String id = this.getIdFromAnnotableEntity(http2Client, policyBuilderContext.getIdGenerator());
            Element http2ClientGoidElement = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:Http2ClientConfigGoid", "goidValue", id);
            assertionElement.insertBefore(http2ClientGoidElement, http2ClientNameEle);
        }
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:Http2Routing";
    }
}

