/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.string.CharacterBlacklistUtil;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class FolderEntityBuilder
implements EntityBuilder {
    private static final Logger LOGGER = Logger.getLogger(FolderEntityBuilder.class.getName());
    private static final Integer ORDER = 100;
    private final IdGenerator idGenerator;

    @Inject
    FolderEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    private Entity buildFolderEntity(Folder folder, String id, String parentFolderId, Document document) {
        Entity entity;
        Element folderElement = DocumentUtils.createElementWithAttribute(document, "l7:Folder", "id", id);
        if (parentFolderId != null) {
            folderElement.setAttribute("folderId", parentFolderId);
        }
        String folderName = folder.getName();
        folderName = CharacterBlacklistUtil.decodeName(folderName);
        folderElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Name", folderName));
        if (parentFolderId == null) {
            entity = new Entity("FOLDER", folderName, id, folderElement, folder);
        } else {
            String filteredPathName = EntityBuilderHelper.getPath(folder.getParentFolder(), folder.getName());
            filteredPathName = CharacterBlacklistUtil.decodePath(filteredPathName);
            entity = EntityBuilderHelper.getEntityWithPathMapping("FOLDER", filteredPathName, filteredPathName, id, folderElement, false, folder);
        }
        entity.setMappingAction("NewOrExisting");
        return entity;
    }

    private List<Entity> buildEntities(Map<String, Folder> entities, EntityBuilder.BundleType bundleType, Document document, String targetFolderPath) {
        if (entities.isEmpty() && StringUtils.isBlank((CharSequence)targetFolderPath) || bundleType == EntityBuilder.BundleType.ENVIRONMENT) {
            return Collections.emptyList();
        }
        HashMap folderChildrenMap = new HashMap();
        Folder rootFolder = entities.remove("");
        if (rootFolder == null) {
            throw new EntityBuilderException("Could not locate root folder.");
        }
        if (StringUtils.isNotBlank((CharSequence)targetFolderPath) && rootFolder != Folder.ROOT_FOLDER) {
            Folder bundleTargetFolder = rootFolder;
            bundleTargetFolder.setId(this.idGenerator.generate());
            bundleTargetFolder.setName(targetFolderPath);
            bundleTargetFolder.setParentFolder(Folder.ROOT_FOLDER);
            bundleTargetFolder.setPath(targetFolderPath + "/");
            entities.put(bundleTargetFolder.getPath(), bundleTargetFolder);
            rootFolder = Folder.ROOT_FOLDER;
            entities.put("", rootFolder);
        } else {
            rootFolder.setId("0000000000000000ffffffffffffec76");
            rootFolder.setName("Root Node");
            entities.put("", rootFolder);
        }
        entities.values().forEach(folder -> this.addFolder((Folder)folder, folderChildrenMap));
        Stream<Entity> folderStream = Stream.of(rootFolder).flatMap(f -> this.expand((Folder)f, folderChildrenMap));
        return folderStream.map(f -> {
            if (f.getId() == null) {
                f.setId(this.idGenerator.generate());
            }
            String parentFolderId = f.getParentFolder() != null ? f.getParentFolder().getId() : null;
            return this.buildFolderEntity((Folder)f, f.getId(), parentFolderId, document);
        }).collect(Collectors.toList());
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        Map<String, Folder> folderMap = Optional.ofNullable(bundle.getFolders()).orElse(Collections.emptyMap());
        return this.buildEntities(folderMap, bundleType, document, bundle.getTargetFolderPath());
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }

    private Stream<Folder> expand(Folder folder, Map<Folder, Collection<Folder>> folderChildrenMap) {
        return Stream.of(folder).flatMap(f -> Stream.concat(Stream.of(f), ((Collection)folderChildrenMap.getOrDefault(f, Collections.emptySet())).stream().flatMap(f2 -> this.expand((Folder)f2, folderChildrenMap))));
    }

    private void addFolder(Folder folder, Map<Folder, Collection<Folder>> folderChildrenMap) {
        if (folder.getParentFolder() != null) {
            folderChildrenMap.compute(folder.getParentFolder(), (k, v) -> {
                if (v == null) {
                    return new HashSet<Folder>(Collections.singleton(folder));
                }
                v.add(folder);
                return v;
            });
        }
    }
}

