/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.MissingGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.IdValidator;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncapsulatedAssertionBuilder
implements PolicyAssertionBuilder {
    private static final Logger LOGGER = Logger.getLogger(EncapsulatedAssertionBuilder.class.getName());
    static final String ENCASS_NAME = "encassName";
    static final String STRING_VALUE = "stringValue";
    static final String BOOLEAN_VALUE = "booleanValue";
    public static final String ZERO_GUID = "00000000-0000-0000-0000-000000000000";

    @Override
    public void buildAssertionElement(Element encapsulatedAssertionElement, PolicyBuilderContext policyBuilderContext) throws DocumentParseException {
        Bundle bundle = policyBuilderContext.getBundle();
        AnnotatedBundle annotatedBundle = policyBuilderContext.getAnnotatedBundle();
        Policy policy = policyBuilderContext.getPolicy();
        if (encapsulatedAssertionElement.hasAttribute(ENCASS_NAME)) {
            String encassName = encapsulatedAssertionElement.getAttribute(ENCASS_NAME);
            Encass encass = this.getEncass(bundle, encassName, annotatedBundle);
            String guid = EncapsulatedAssertionBuilder.findEncassReferencedGuid(policy, encass, encapsulatedAssertionElement, encassName);
            this.updateEncapsulatedAssertion(policyBuilderContext, encapsulatedAssertionElement, encass, encassName, guid);
        } else {
            if (!EncapsulatedAssertionBuilder.isNoOpIfConfigMissing(encapsulatedAssertionElement)) {
                Element guidElement = DocumentUtils.getSingleChildElement(encapsulatedAssertionElement, "L7p:EncapsulatedAssertionConfigGuid", true);
                Element nameElement = DocumentUtils.getSingleChildElement(encapsulatedAssertionElement, "L7p:EncapsulatedAssertionConfigName", true);
                throw new EntityBuilderException("No encassName specified for encass in policy: '" + policy.getPath() + "' GUID: '" + (guidElement != null ? guidElement.getAttribute(STRING_VALUE) : null) + "' Name: '" + (nameElement != null ? nameElement.getAttribute(STRING_VALUE) : null) + "'");
            }
            LOGGER.log(Level.FINE, "No encassName specified for encass in policy: \"{0}\". Since NoOp is true, this will be treated as a No Op.", policy.getPath());
        }
    }

    private Encass getEncass(Bundle bundle, String name, AnnotatedBundle annotatedBundle) {
        LOGGER.log(Level.FINE, "Looking for referenced encass: {0}", name);
        AtomicReference<Encass> referenceEncass = annotatedBundle != null ? new AtomicReference<Encass>(annotatedBundle.getEncasses().get(name)) : new AtomicReference<Encass>(bundle.getEncasses().get(name));
        if (referenceEncass.get() == null) {
            MissingGatewayEntity missingEntity;
            bundle.getDependencies().forEach(b -> {
                Encass encassDependency = b.getEncasses().get(name);
                if (encassDependency != null) {
                    if (!referenceEncass.compareAndSet(null, encassDependency)) {
                        throw new EntityBuilderException("Found multiple encasses in dependency bundles with name: " + name);
                    }
                    DependentBundle dependentBundle = b.getDependentBundleFrom();
                    if (dependentBundle != null && dependentBundle.getType() != null) {
                        if (annotatedBundle != null) {
                            annotatedBundle.addDependentBundle(dependentBundle);
                        } else {
                            bundle.addDependentBundle(dependentBundle);
                        }
                    }
                }
            });
            if (referenceEncass.get() == null && (missingEntity = bundle.getMissingEntities().get(name)) != null && missingEntity.isExcluded()) {
                LOGGER.log(Level.WARNING, "Resolving the referenced encass {0} as known excluded entity with guid: {1}", new Object[]{name, missingEntity.getGuid()});
                referenceEncass.set(this.getExcludedEncass(missingEntity.getGuid()));
            }
        }
        return referenceEncass.get();
    }

    private Encass getExcludedEncass(String guid) {
        Encass missingEncass = new Encass();
        missingEncass.setGuid(guid);
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.add(AnnotableEntity.EXCLUDE_ANNOTATION);
        missingEncass.setAnnotations(annotations);
        return missingEncass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String findEncassReferencedGuid(Policy policy, Encass encass, Element encapsulatedAssertionElement, String name) {
        if (encass != null) return encass.getGuid();
        if (!EncapsulatedAssertionBuilder.isNoOpIfConfigMissing(encapsulatedAssertionElement)) throw new EntityBuilderException("Could not find referenced encass with name: '" + name + "'. In policy: " + policy.getPath());
        LOGGER.log(Level.FINE, "Could not find referenced encass with name: \"{0}\". In policy: \"{1}\". Since NoOp is true, this will be treated as a No Op.", new String[]{name, policy.getPath()});
        return ZERO_GUID;
    }

    private void updateEncapsulatedAssertion(PolicyBuilderContext policyBuilderContext, Node encapsulatedAssertionElement, Encass encass, String name, String guid) {
        AnnotatedEntity<? extends GatewayEntity> annotatedEntity;
        String encassName = name;
        String encassGuid = guid;
        IdGenerator idGenerator = policyBuilderContext.getIdGenerator();
        AnnotatedBundle annotatedBundle = policyBuilderContext.getAnnotatedBundle();
        AnnotatedEntity<? extends GatewayEntity> annotatedEntity2 = annotatedEntity = annotatedBundle != null ? annotatedBundle.getAnnotatedEntity() : null;
        if (encass != null && !encass.isExcluded() && annotatedEntity != null) {
            AnnotatedEntity annotatedEncassEntity = encass.getAnnotatedEntity();
            if (encass.isParentEntityShared()) {
                if (annotatedEncassEntity != null) {
                    if (annotatedEncassEntity.getGuid() != null) {
                        if (IdValidator.isValidGuid(annotatedEncassEntity.getGuid())) {
                            encassGuid = annotatedEncassEntity.getGuid();
                            encass.setGuid(encassGuid);
                        } else {
                            LOGGER.log(Level.WARNING, "ignoring given invalid guid {0} for entity {1}", new String[]{annotatedEncassEntity.getGuid(), name});
                        }
                    }
                    if (annotatedEncassEntity.getId() != null) {
                        if (IdValidator.isValidGoid(annotatedEncassEntity.getId())) {
                            encass.setId(annotatedEncassEntity.getId());
                        } else {
                            LOGGER.log(Level.WARNING, "ignoring given invalid goid {0} for entity {1}", new String[]{annotatedEncassEntity.getId(), name});
                        }
                    }
                }
            } else {
                encassGuid = idGenerator.generateGuid();
                encass.setGuid(encassGuid);
                encass.setId(idGenerator.generate());
            }
            encassName = annotatedBundle.applyUniqueName(encassName, EntityBuilder.BundleType.DEPLOYMENT, encass.isParentEntityShared());
        }
        Element encapsulatedAssertionConfigNameElement = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:EncapsulatedAssertionConfigName", STRING_VALUE, encassName);
        Node firstChild = encapsulatedAssertionElement.getFirstChild();
        if (firstChild != null) {
            encapsulatedAssertionElement.insertBefore(encapsulatedAssertionConfigNameElement, firstChild);
        } else {
            encapsulatedAssertionElement.appendChild(encapsulatedAssertionConfigNameElement);
        }
        Element encapsulatedAssertionConfigGuidElement = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:EncapsulatedAssertionConfigGuid", STRING_VALUE, encassGuid);
        encapsulatedAssertionElement.insertBefore(encapsulatedAssertionConfigGuidElement, encapsulatedAssertionElement.getFirstChild());
        ((Element)encapsulatedAssertionElement).removeAttribute(ENCASS_NAME);
    }

    private static boolean isNoOpIfConfigMissing(Element encapsulatedAssertionElement) {
        Element noOpElement = DocumentUtils.getSingleChildElement(encapsulatedAssertionElement, "L7p:NoOpIfConfigMissing", true);
        if (noOpElement == null) {
            return false;
        }
        String isNoOp = noOpElement.getAttribute(BOOLEAN_VALUE);
        return Boolean.valueOf(isNoOp);
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:Encapsulated";
    }
}

