/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.ClusterProperty;
import com.ca.apim.gateway.cagatewayconfig.beans.GlobalEnvironmentProperty;
import com.ca.apim.gateway.cagatewayconfig.beans.PropertiesEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class ClusterPropertyEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 500;
    private final IdGenerator idGenerator;

    @Inject
    ClusterPropertyEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    private List<Entity> buildEntities(Map<String, ?> globalProperties, Map<String, ?> clusterProperties, EntityBuilder.BundleType bundleType, Document document) {
        Stream.Builder streamBuilder = Stream.builder();
        switch (bundleType) {
            case DEPLOYMENT: {
                clusterProperties.entrySet().stream().map(propertyEntry -> {
                    if (globalProperties.containsKey("gateway." + (String)propertyEntry.getKey())) {
                        throw new EntityBuilderException("The Cluster property: '" + (String)propertyEntry.getKey() + "' is defined in both static.properties and env.properties");
                    }
                    return this.buildClusterPropertyEntity((String)propertyEntry.getKey(), (ClusterProperty)propertyEntry.getValue(), document);
                }).forEach(streamBuilder);
                globalProperties.keySet().stream().filter(o -> o.startsWith("gateway.")).map(o -> EntityBuilderHelper.getEntityWithOnlyMapping("CLUSTER_PROPERTY", o.substring("gateway.".length()), this.idGenerator.generate())).forEach(streamBuilder);
                break;
            }
            case ENVIRONMENT: {
                globalProperties.entrySet().stream().filter(propertyEntry -> ((String)propertyEntry.getKey()).startsWith("gateway.")).map(propertyEntry -> this.buildClusterPropertyEntity(((String)propertyEntry.getKey()).substring("gateway.".length()), (GlobalEnvironmentProperty)propertyEntry.getValue(), document)).forEach(streamBuilder);
                break;
            }
            default: {
                throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
            }
        }
        return streamBuilder.build().collect(Collectors.toList());
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        Map globalEnvironmentProperties = Optional.ofNullable(bundle.getGlobalEnvironmentProperties()).orElse(Collections.emptyMap());
        Map clusterPropertyMap = Optional.ofNullable(bundle.getStaticProperties()).orElse(Collections.emptyMap());
        return this.buildEntities(globalEnvironmentProperties, clusterPropertyMap, bundleType, document);
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }

    private Entity buildClusterPropertyEntity(String name, PropertiesEntity value, Document document) {
        String id = this.idGenerator.generate();
        return EntityBuilderHelper.getEntityWithNameMapping("CLUSTER_PROPERTY", name, id, ClusterPropertyEntityBuilder.buildClusterPropertyElement(name, id, value.getValue(), document));
    }

    private static Element buildClusterPropertyElement(String name, String id, String value, Document document) {
        return ClusterPropertyEntityBuilder.buildClusterPropertyElement(name, id, value, document, Collections.emptyMap());
    }

    private static Element buildClusterPropertyElement(String name, String id, String value, Document document, Map<String, String> valueAttributes) {
        Element clusterPropertyElement = DocumentUtils.createElementWithAttribute(document, "l7:ClusterProperty", "id", id);
        clusterPropertyElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Name", name));
        Element valueElement = DocumentUtils.createElementWithTextContent(document, "l7:Value", value);
        valueAttributes.forEach(valueElement::setAttribute);
        clusterPropertyElement.appendChild(valueElement);
        return clusterPropertyElement;
    }
}

