/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class BundleDocumentBuilder {
    static final String L7 = "xmlns:l7";
    static final String GATEWAY_MANAGEMENT = "http://ns.l7tech.com/2010/04/gateway-management";

    public Element build(Document document, List<Entity> entities) {
        Element references = document.createElement("l7:References");
        Element mappings = document.createElement("l7:Mappings");
        Element bundle = DocumentUtils.createElementWithChildren(document, "l7:Bundle", references, mappings);
        entities.forEach(e -> this.addEntity(references, mappings, (Entity)e, document));
        bundle.setAttribute(L7, GATEWAY_MANAGEMENT);
        return bundle;
    }

    private void addEntity(Element references, Element mappings, Entity entity, Document document) {
        if (entity.getXml() != null) {
            Element entityItem = this.buildEntityItem(entity, document);
            references.appendChild(entityItem);
        }
        Element entityMapping = this.buildEntityMapping(entity, document);
        mappings.appendChild(entityMapping);
    }

    private Element buildEntityMapping(Entity entity, Document document) {
        Element mapping = DocumentUtils.createElementWithAttributes(document, "l7:Mapping", (Map<String, String>)ImmutableMap.of((Object)"action", (Object)(entity.getMappingAction() == null ? EntityBuilderHelper.getDefaultEntityMappingAction() : entity.getMappingAction()), (Object)"srcId", (Object)entity.getId(), (Object)"type", (Object)entity.getType()));
        BuilderUtils.buildAndAppendPropertiesElement(entity.getMappingProperties(), document, mapping);
        return mapping;
    }

    private Element buildEntityItem(Entity entity, Document document) {
        return DocumentUtils.createElementWithChildren(document, "l7:Item", DocumentUtils.createElementWithTextContent(document, "l7:Name", entity.getName()), DocumentUtils.createElementWithTextContent(document, "l7:Id", entity.getId()), DocumentUtils.createElementWithTextContent(document, "l7:Type", entity.getType()), DocumentUtils.createElementWithChildren(document, "l7:Resource", entity.getXml()));
    }
}

