/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleMetadata;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Element;

public class BundleArtifacts {
    private final Artifact installBundle;
    private final Artifact deleteBundle;
    private final BundleMetadata bundleMetadata;
    private final Set<Artifact> privateKeyContexts = new HashSet<Artifact>();

    public BundleArtifacts(Element bundle, Element deleteBundle, BundleMetadata bundleMetadata, String bundleFileName, String deleteBundleFileName) {
        this.installBundle = new Artifact(bundle, bundleFileName);
        this.deleteBundle = new Artifact(deleteBundle, deleteBundleFileName);
        this.bundleMetadata = bundleMetadata;
    }

    public Artifact getInstallBundle() {
        return this.installBundle;
    }

    public Artifact getDeleteBundle() {
        return this.deleteBundle;
    }

    public BundleMetadata getBundleMetadata() {
        return this.bundleMetadata;
    }

    public void addPrivateKeyContext(Element contextXml, String filename) {
        this.privateKeyContexts.add(new Artifact(contextXml, filename));
    }

    public Set<Artifact> getPrivateKeyContexts() {
        return this.privateKeyContexts;
    }

    public static class Artifact {
        private final Element element;
        private final String filename;

        public Artifact(Element element, String filename) {
            this.element = element;
            this.filename = filename;
        }

        public Element getElement() {
            return this.element;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Artifact artifact = (Artifact)o;
            return Objects.equals(this.filename, artifact.filename);
        }

        public int hashCode() {
            return Objects.hash(this.filename);
        }
    }
}

