/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.EntityTypeRegistry;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import java.util.function.Predicate;

public final class BuilderConstants {
    public static final String STORED_PASSWORD_REF_FORMAT = "${secpass.%s.plaintext}";
    public static final String BUNDLE_TYPE_ALL = "ALL";
    public static final Predicate<Entity> FILTER_ENV_ENTITIES = new Predicate<Entity>(){

        @Override
        public boolean test(Entity entity) {
            return !EntityTypeRegistry.NON_ENV_ENTITY_TYPES.contains(entity.getType());
        }
    };
    public static final Predicate<Entity> FILTER_NON_ENV_ENTITIES_EXCLUDING_FOLDER = new Predicate<Entity>(){

        @Override
        public boolean test(Entity entity) {
            return entity.getGatewayEntity() != null && !"FOLDER".equals(entity.getType()) && EntityTypeRegistry.NON_ENV_ENTITY_TYPES.contains(entity.getType());
        }
    };
    public static final Predicate<Entity> FILTER_OUT_DEFAULT_LISTEN_PORTS = new Predicate<Entity>(){

        @Override
        public boolean test(Entity entity) {
            return !"SSG_CONNECTOR".equals(entity.getType()) || !"Default HTTP (8080)".equals(entity.getName()) && !"Default HTTPS (8443)".equals(entity.getName());
        }
    };
    public static final Predicate<Entity> FILTER_OUT_PRIVATE_KEYS = entity -> !"SSG_KEY_ENTRY".equals(entity.getType());
    public static final Predicate<Entity> FILTER_NON_ENV_ENTITIES = new Predicate<Entity>(){

        @Override
        public boolean test(Entity entity) {
            return EntityTypeRegistry.NON_ENV_ENTITY_TYPES.contains(entity.getType());
        }
    };

    private BuilderConstants() {
    }
}

