/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.PropertiesEntity;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="SECURE_PASSWORD")
@ConfigurationFile(name="stored-passwords", type=ConfigurationFile.FileType.PROPERTIES)
@EnvironmentType(value="PASSWORD")
public class StoredPassword
extends PropertiesEntity {
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_USAGE_FROM_VARIABLE = "usageFromVariable";
    private String password;
    private Map<String, Object> properties;

    public StoredPassword() {
    }

    private StoredPassword(Builder builder) {
        this.setId(builder.id);
        this.setName(builder.name);
        this.properties = builder.properties;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, @Nullable File rootFolder, IdGenerator idGenerator) {
        this.addDefaultProperties();
    }

    public void addDefaultProperties() {
        this.properties = StoredPassword.fillDefaultProperties(this.getName(), this.properties);
    }

    public static Map<String, Object> fillDefaultProperties(String name, Map<String, Object> properties) {
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        properties.putIfAbsent(PROPERTY_DESCRIPTION, name);
        properties.putIfAbsent(PROPERTY_TYPE, Type.PASSWORD.getName());
        properties.putIfAbsent(PROPERTY_USAGE_FROM_VARIABLE, true);
        return properties;
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public void setKey(String key) {
        this.setName(key);
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public void setValue(String value) {
        this.setPassword(value);
    }

    public boolean isType(Type type) {
        return this.properties != null && Objects.equals(this.properties.get(PROPERTY_TYPE), type.getName());
    }

    public static class Builder {
        private String id;
        private String name;
        private Map<String, Object> properties;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public StoredPassword build() {
            return new StoredPassword(this);
        }
    }

    public static enum Type {
        PASSWORD("Password"),
        PEM_PRIVATE_KEY("PEM Private Key");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

