/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.AuditPolicy;
import com.ca.apim.gateway.cagatewayconfig.beans.GlobalPolicy;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.config.EntityConfigException;
import com.google.common.base.MoreObjects;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum PolicyType {
    INCLUDE("Include", Policy.class, new String[0]),
    SERVICE_OPERATION("Service Operation", Policy.class, new String[0]),
    GLOBAL("Global", GlobalPolicy.class, new String[0]),
    INTERNAL("Internal", AuditPolicy.class, "audit-lookup", "audit-sink", "audit-message-filter", "audit-viewer");

    private String type;
    private List<String> tags;
    private Class<? extends Policy> policyClass;

    private PolicyType(String type, Class<? extends Policy> policyClass, String ... tags) {
        this.type = type;
        this.policyClass = policyClass;
        this.tags = new ArrayList<Object>(Arrays.asList((Object[])MoreObjects.firstNonNull((Object)tags, (Object)new String[0])));
    }

    public String getType() {
        return this.type;
    }

    public Policy createPolicyObject() {
        try {
            Constructor<? extends Policy> constructor = this.policyClass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new EntityConfigException("Could not create policy object for " + this.policyClass.getSimpleName(), e);
        }
    }

    public static boolean isValidType(String type, String tag) {
        PolicyType policyType = Arrays.stream(PolicyType.values()).filter(t -> t.type.equals(type)).findFirst().orElse(null);
        if (policyType == null) {
            return false;
        }
        return StringUtils.isEmpty((CharSequence)tag) || policyType.tags.isEmpty() || policyType.tags.contains(tag);
    }

    public static PolicyType fromType(String policyType) {
        return Arrays.stream(PolicyType.values()).filter(t -> t.type.equals(policyType)).findFirst().orElse(null);
    }
}

