/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import java.util.stream.Stream;

public enum KeyStoreType {
    PKCS12_SOFTWARE("00000000000000000000000000000002", "Software DB"),
    PKCS11_HARDWARE("00000000000000000000000000000001", "HSM"),
    LUNA_HARDWARE("00000000000000000000000000000003", "SafeNet HSM"),
    NCIPHER_HARDWARE("00000000000000000000000000000004", "nCipher HSM"),
    GENERIC("00000000000000000000000000000005", "Generic");

    private String id;
    private String name;

    private KeyStoreType(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String generateKeyId(String keyAlias) {
        return this.id + ":" + keyAlias;
    }

    public static KeyStoreType fromName(String name) {
        return Stream.of(KeyStoreType.values()).filter(k -> k.name.equals(name)).findFirst().orElse(GENERIC);
    }

    public static KeyStoreType fromId(String id) {
        return Stream.of(KeyStoreType.values()).filter(k -> id.equals(k.id)).findFirst().orElse(GENERIC);
    }
}

