/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.InboundJmsDestinationDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.OutboundJmsDestinationDetail;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotationDeserializer;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="JMS_ENDPOINT")
@ConfigurationFile(name="jms-destinations", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="JMS_DESTINATION")
public class JmsDestination
extends GatewayEntity
implements AnnotableEntity {
    public static final String PROVIDER_TYPE_GENERIC = null;
    public static final String PROVIDER_TYPE_TIBCO_EMS = "TIBCO EMS";
    public static final String PROVIDER_TYPE_WEBSPHERE_MQ_OVER_LDAP = "WebSphere MQ over LDAP";
    public static final int DEFAULT_DEDICATED_CONSUMER_CONNECTION_SIZE = 1;
    public static final long DEFAULT_MAX_INBOUND_MESSAGE_SIZE = -1L;
    private String providerType;
    private String initialContextFactoryClassName;
    private String jndiUrl;
    private String jndiUsername;
    private String jndiPasswordRef;
    private String jndiPassword;
    private Map<String, Object> jndiProperties;
    private DestinationType destinationType;
    private String connectionFactoryName;
    private String destinationName;
    private String destinationUsername;
    private String destinationPasswordRef;
    private String destinationPassword;
    private InboundJmsDestinationDetail inboundDetail;
    private OutboundJmsDestinationDetail outboundDetail;
    private Map<String, Object> additionalProperties;
    @JsonDeserialize(using=AnnotationDeserializer.class)
    private Set<Annotation> annotations;
    @JsonIgnore
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public AnnotatedEntity getAnnotatedEntity() {
        if (this.annotatedEntity == null && this.annotations != null) {
            this.annotatedEntity = this.createAnnotatedEntity();
        }
        return this.annotatedEntity;
    }

    @Override
    public String getEntityType() {
        return "JMS_ENDPOINT";
    }

    @VisibleForTesting
    public void setAnnotatedEntity(AnnotatedEntity<Encass> annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    public JmsDestination() {
    }

    private JmsDestination(Builder builder) {
        this.setName(builder.name);
        this.setId(builder.id);
        this.providerType = builder.providerType;
        this.initialContextFactoryClassName = builder.initialContextFactoryClassName;
        this.jndiUrl = builder.jndiUrl;
        this.jndiUsername = builder.jndiUsername;
        this.jndiPasswordRef = builder.jndiPasswordRef;
        this.jndiPassword = builder.jndiPassword;
        this.jndiProperties = builder.jndiProperties;
        this.destinationType = builder.destinationType;
        this.connectionFactoryName = builder.connectionFactoryName;
        this.destinationName = builder.destinationName;
        this.destinationUsername = builder.destinationUsername;
        this.destinationPasswordRef = builder.destinationPasswordRef;
        this.destinationPassword = builder.destinationPassword;
        this.inboundDetail = builder.inboundDetail;
        this.outboundDetail = builder.outboundDetail;
        this.additionalProperties = builder.additionalProperties;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    public String getInitialContextFactoryClassName() {
        return this.initialContextFactoryClassName;
    }

    public void setInitialContextFactoryClassName(String initialContextFactoryClassName) {
        this.initialContextFactoryClassName = initialContextFactoryClassName;
    }

    public Map<String, Object> getJndiProperties() {
        return this.jndiProperties;
    }

    public void setJndiProperties(Map<String, Object> jndiProperties) {
        this.jndiProperties = jndiProperties;
    }

    public String getJndiUrl() {
        return this.jndiUrl;
    }

    public void setJndiUrl(String jndiUrl) {
        this.jndiUrl = jndiUrl;
    }

    public String getJndiUsername() {
        return this.jndiUsername;
    }

    public void setJndiUsername(String jndiUsername) {
        this.jndiUsername = jndiUsername;
    }

    public String getJndiPasswordRef() {
        return this.jndiPasswordRef;
    }

    public void setJndiPasswordRef(String jndiPasswordRef) {
        this.jndiPasswordRef = jndiPasswordRef;
    }

    public String getJndiPassword() {
        return this.jndiPassword;
    }

    public void setJndiPassword(String jndiPassword) {
        this.jndiPassword = jndiPassword;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getDestinationUsername() {
        return this.destinationUsername;
    }

    public void setDestinationUsername(String destinationUsername) {
        this.destinationUsername = destinationUsername;
    }

    public String getDestinationPasswordRef() {
        return this.destinationPasswordRef;
    }

    public void setDestinationPasswordRef(String destinationPasswordRef) {
        this.destinationPasswordRef = destinationPasswordRef;
    }

    public String getDestinationPassword() {
        return this.destinationPassword;
    }

    public void setDestinationPassword(String destinationPassword) {
        this.destinationPassword = destinationPassword;
    }

    public InboundJmsDestinationDetail getInboundDetail() {
        return this.inboundDetail;
    }

    public void setInboundDetail(InboundJmsDestinationDetail inboundDetail) {
        this.inboundDetail = inboundDetail;
    }

    public OutboundJmsDestinationDetail getOutboundDetail() {
        return this.outboundDetail;
    }

    public void setOutboundDetail(OutboundJmsDestinationDetail outboundDetail) {
        this.outboundDetail = outboundDetail;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, @Nullable File rootFolder, IdGenerator idGenerator) {
        if (this.getJndiPasswordRef() != null && this.getJndiPassword() != null) {
            throw new ConfigLoadException("Cannot specify both a password reference and a password for JNDI password for JMS destination: " + entityKey);
        }
        if (this.getDestinationPasswordRef() != null && this.getDestinationPassword() != null) {
            throw new ConfigLoadException("Cannot specify both a password reference and a password for Destination password for JMS destination: " + entityKey);
        }
        if (this.inboundDetail == null && this.outboundDetail == null) {
            throw new ConfigLoadException("Must specify inbound or outbound details for JMS destination: " + entityKey);
        }
        if (this.inboundDetail != null && this.outboundDetail != null) {
            throw new ConfigLoadException("Cannot specify both an inbound and an outbound details for JMS destination: " + entityKey);
        }
        this.setId(idGenerator.generate());
    }

    @Override
    public String getId() {
        if (this.getAnnotatedEntity() != null && this.annotatedEntity.getId() != null) {
            return this.annotatedEntity.getId();
        }
        return super.getId();
    }

    public static class Builder {
        private Map<String, Object> additionalProperties;
        private OutboundJmsDestinationDetail outboundDetail;
        private InboundJmsDestinationDetail inboundDetail;
        private String destinationPassword;
        private String destinationPasswordRef;
        private String destinationUsername;
        private String destinationName;
        private String connectionFactoryName;
        private DestinationType destinationType;
        private Map<String, Object> jndiProperties;
        private String jndiPassword;
        private String jndiPasswordRef;
        private String jndiUsername;
        private String jndiUrl;
        private String initialContextFactoryClassName;
        private String providerType;
        private String id;
        private String name;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        public Builder initialContextFactoryClassName(String initialContextFactoryClassName) {
            this.initialContextFactoryClassName = initialContextFactoryClassName;
            return this;
        }

        public Builder jndiUrl(String jndiUrl) {
            this.jndiUrl = jndiUrl;
            return this;
        }

        public Builder jndiUsername(String jndiUsername) {
            this.jndiUsername = jndiUsername;
            return this;
        }

        public Builder jndiPasswordRef(String jndiPasswordRef) {
            this.jndiPasswordRef = jndiPasswordRef;
            return this;
        }

        public Builder jndiPassword(String jndiPassword) {
            this.jndiPassword = jndiPassword;
            return this;
        }

        public Builder jndiProperties(Map<String, Object> jndiProperties) {
            this.jndiProperties = jndiProperties;
            return this;
        }

        public Builder destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        public Builder connectionFactoryName(String connectionFactoryName) {
            this.connectionFactoryName = connectionFactoryName;
            return this;
        }

        public Builder destinationUsername(String destinationUsername) {
            this.destinationUsername = destinationUsername;
            return this;
        }

        public Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public Builder destinationPasswordRef(String destinationPasswordRef) {
            this.destinationPasswordRef = destinationPasswordRef;
            return this;
        }

        public Builder destinationPassword(String destinationPassword) {
            this.destinationPassword = destinationPassword;
            return this;
        }

        public Builder inboundDetail(InboundJmsDestinationDetail inboundDetail) {
            this.inboundDetail = inboundDetail;
            return this;
        }

        public Builder outboundDetail(OutboundJmsDestinationDetail outboundDetail) {
            this.outboundDetail = outboundDetail;
            return this;
        }

        public Builder additionalProperties(Map<String, Object> additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public JmsDestination build() {
            return new JmsDestination(this);
        }
    }

    public static enum DestinationType {
        QUEUE("Queue"),
        TOPIC("Topic");

        private String type;

        private DestinationType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static DestinationType fromType(String type) {
            return Arrays.stream(DestinationType.values()).filter(c -> c.type.equals(type)).findFirst().orElse(null);
        }
    }
}

