/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.BindOnlyLdapIdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.FederatedIdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.FullLdapIdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotationDeserializer;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Named(value="ID_PROVIDER_CONFIG")
@ConfigurationFile(name="identity-providers", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="IDENTITY_PROVIDER")
public class IdentityProvider
extends GatewayEntity
implements AnnotableEntity {
    public static final String INTERNAL_IDP_ID = "0000000000000000fffffffffffffffe";
    public static final String INTERNAL_IDP_NAME = "Internal Identity Provider";
    private IdentityProviderType type;
    private Map<String, Object> properties;
    @JsonDeserialize(using=AnnotationDeserializer.class)
    private Set<Annotation> annotations;
    @JsonIgnore
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=BindOnlyLdapIdentityProviderDetail.class, name="BIND_ONLY_LDAP"), @JsonSubTypes.Type(value=FullLdapIdentityProviderDetail.class, name="LDAP"), @JsonSubTypes.Type(value=FederatedIdentityProviderDetail.class, name="FEDERATED")})
    private IdentityProviderDetail identityProviderDetail;

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public AnnotatedEntity getAnnotatedEntity() {
        if (this.annotatedEntity == null && this.annotations != null) {
            this.annotatedEntity = this.createAnnotatedEntity();
        }
        return this.annotatedEntity;
    }

    @Override
    public String getEntityType() {
        return "ID_PROVIDER_CONFIG";
    }

    @VisibleForTesting
    public void setAnnotatedEntity(AnnotatedEntity<Encass> annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    public IdentityProvider() {
    }

    private IdentityProvider(Builder builder) {
        this.setId(builder.id);
        this.setName(builder.name);
        this.type = builder.type;
        this.properties = builder.properties;
        this.identityProviderDetail = builder.identityProviderDetail;
    }

    public IdentityProviderType getType() {
        return this.type;
    }

    public void setType(IdentityProviderType type) {
        this.type = type;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public IdentityProviderDetail getIdentityProviderDetail() {
        return this.identityProviderDetail;
    }

    public void setIdentityProviderDetail(IdentityProviderDetail identityProviderDetail) {
        this.identityProviderDetail = identityProviderDetail;
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, File rootFolder, IdGenerator idGenerator) {
        this.setId(idGenerator.generate());
    }

    @Override
    public String getId() {
        if (this.getAnnotatedEntity() != null && this.annotatedEntity.getId() != null) {
            return this.annotatedEntity.getId();
        }
        return super.getId();
    }

    public static class Builder {
        private String name;
        private String id;
        private IdentityProviderType type;
        private Map<String, Object> properties;
        private IdentityProviderDetail identityProviderDetail;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(IdentityProviderType type) {
            this.type = type;
            return this;
        }

        public Builder identityProviderDetail(IdentityProviderDetail identityProviderDetail) {
            this.identityProviderDetail = identityProviderDetail;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public IdentityProvider build() {
            return new IdentityProvider(this);
        }
    }

    public static enum IdentityProviderType {
        INTERNAL("Internal"),
        LDAP("LDAP"),
        FEDERATED("Federated"),
        BIND_ONLY_LDAP("Simple LDAP"),
        POLICY_BACKED("Policy-backed");

        private String value;

        private IdentityProviderType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static IdentityProviderType fromType(String type) {
            return Arrays.stream(IdentityProviderType.values()).filter(c -> c.value.equals(type)).findFirst().orElse(null);
        }
    }
}

