/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.FolderTreeException;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FolderTree {
    private Map<String, Folder> idFolderMap = new HashMap<String, Folder>();
    private Map<String, Collection<Folder>> folderChildrenMap = new HashMap<String, Collection<Folder>>();
    private Folder rootFolder;

    public FolderTree(Collection<Folder> folders) {
        folders.forEach(this::addFolder);
        if (this.rootFolder == null) {
            throw new FolderTreeException("Root folder could not be found in bundle");
        }
        Set orphanedTrees = this.folderChildrenMap.keySet().stream().filter(id -> !this.idFolderMap.containsKey(id)).collect(Collectors.toSet());
        if (!orphanedTrees.isEmpty()) {
            throw new FolderTreeException("Orphaned folder Trees detected:" + orphanedTrees.stream().reduce("", (s1, s2) -> s1 + " " + s2));
        }
    }

    private synchronized void addFolder(Folder folder) {
        this.idFolderMap.put(folder.getId(), folder);
        if (folder.getParentFolder() != null && !folder.getParentFolder().getId().isEmpty()) {
            this.folderChildrenMap.compute(folder.getParentFolder().getId(), (k, v) -> {
                if (v == null) {
                    return new HashSet<Folder>(Collections.singleton(folder));
                }
                v.add(folder);
                return v;
            });
        } else if (this.rootFolder == null) {
            this.rootFolder = folder;
        } else {
            throw new FolderTreeException("Detected multiple root folders: " + this.rootFolder.toString() + " AND " + folder.toString());
        }
    }

    public Stream<Folder> stream() {
        return Stream.of(this.rootFolder).flatMap(this::expand);
    }

    public Folder getRootFolder() {
        return this.rootFolder;
    }

    private Stream<Folder> expand(Folder folder) {
        return Stream.of(folder).flatMap(f -> Stream.concat(Stream.of(f), ((Collection)this.folderChildrenMap.getOrDefault(f.getId(), Collections.emptySet())).stream().flatMap(this::expand)));
    }

    public String getFormattedPath(Folder folder) {
        return PathUtils.unixPath(this.getPath(folder));
    }

    public Path getPath(Folder folder) {
        Path path;
        Folder currentFolder = folder;
        Path path2 = path = currentFolder.getParentFolder() == null ? Paths.get("", new String[0]) : Paths.get(currentFolder.getName(), new String[0]);
        while (currentFolder.getParentFolder() != null) {
            path = Paths.get((currentFolder = this.idFolderMap.get(currentFolder.getParentFolder().getId())).getParentFolder() == null ? "" : currentFolder.getName(), new String[0]).resolve(path);
        }
        return path;
    }

    public Folder getFolderById(String folderId) {
        return this.idFolderMap.get(folderId);
    }
}

